using System;
using System.Collections;
using System.IO;
using System.Reflection;

using SystemNeo;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// o񂩂 C# ̃\[XR[h𐶐܂B
	/// </summary>
	internal class CSharpCodeGeneratorNeo : CodeGeneratorNeo
	{
		#region private static fields
		private static readonly string[] genericArgumentBrackets = {"<", ">"};
		private static readonly IDictionary typeNameAliases = new Hashtable();
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public override string[] GenericArgumentBrackets
		{
			get {
				return genericArgumentBrackets;
			}
		}

		// static RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		static CSharpCodeGeneratorNeo()
		{
			InitializeTypeNameAliases();
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="type"></param>
		/// <returns></returns>
		public override string GetTypeNameAlias(TypeNeo type)
		{
			ArgumentUtil.AssertNull(type, "type");
			return (string)typeNameAliases[(Type)type];
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="elementType"></param>
		protected override void AppendByRefTypeNameInternal(TextWriter writer, TypeNeo elementType)
		{
			writer.Write("ref ");
			base.AppendTypeNameInternal(writer, elementType);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="param"></param>
		/// <param name="name"></param>
		protected override void AppendParameter(TextWriter writer, ParameterInfo param, bool name)
		{
			this.AppendTypeNameInternal(writer, param.ParameterType);
			if (name) {
				writer.Write(" ");
				writer.Write(param.Name);
			}
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		private static void InitializeTypeNameAliases()
		{
			typeNameAliases[typeof(bool)]    = "bool";
			typeNameAliases[typeof(byte)]    = "byte";
			typeNameAliases[typeof(char)]    = "char";
			typeNameAliases[typeof(decimal)] = "decimal";
			typeNameAliases[typeof(double)]  = "double";
			typeNameAliases[typeof(float)]   = "float";
			typeNameAliases[typeof(int)]     = "int";
			typeNameAliases[typeof(long)]    = "long";
			typeNameAliases[typeof(object)]  = "object";
			typeNameAliases[typeof(sbyte)]   = "sbyte";
			typeNameAliases[typeof(short)]   = "short";
			typeNameAliases[typeof(string)]  = "string";
			typeNameAliases[typeof(uint)]    = "uint";
			typeNameAliases[typeof(ulong)]   = "ulong";
			typeNameAliases[typeof(ushort)]  = "ushort";
			typeNameAliases[typeof(void)]    = "void";
		}
	}
}
