using System;
using System.Reflection;
using System.Text;

namespace SystemNeo.Reflection
{
	/// <summary>
	///
	/// </summary>
	public class LateBinder
	{
		// ^ //

		#region private types

		private enum AccessKind {
			Direct,
			Call,
			Get,
			Item
		}

		#endregion

		#region private fields

		private static readonly object[] EmptyObjectArray = new object[] {};
		private static readonly Type[] EmptyTypeArray = new Type[] {};

		private const BindingFlags DefaultBinding
				= BindingFlags.Instance | BindingFlags.Static | BindingFlags.Public;

		private AccessKind accessKind;
		private string memberName;
		private object[] @params;
		private object target;

		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <param name="params"></param>
		/// <returns></returns>
		public LateBinder this[string name, params object[] @params]
		{
			get {
				return new LateBinder(this, AccessKind.Item, name, @params);
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="target"></param>
		public LateBinder(object target) : this(target, AccessKind.Direct, null, null) {}

		#region private constructors

		/// <summary>
		/// 
		/// </summary>
		/// <param name="target"></param>
		/// <param name="accessKind"></param>
		/// <param name="memberName"></param>
		/// <param name="params"></param>
		private LateBinder(object target,
				AccessKind accessKind, string memberName, params object[] @params)
		{
			this.target = target;
			this.accessKind = accessKind;
			this.memberName = memberName;
			this.@params = @params;
		}

		#endregion

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <param name="params"></param>
		/// <returns></returns>
		public LateBinder Call(string name, params object[] @params)
		{
			return new LateBinder(this, AccessKind.Call, name, @params);
		}

		/// <summary>
		///
		/// </summary>
		public object Eval()
		{
			switch (this.accessKind) {
			case AccessKind.Direct:
				return this.target;
			case AccessKind.Call:
				return this.EvalCall();
			case AccessKind.Get:
				return this.EvalGet();
			default:
				return this.EvalItem();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="name"></param>
		/// <param name="params"></param>
		/// <returns></returns>
		public LateBinder Get(string name, params object[] @params)
		{
			return new LateBinder(this, AccessKind.Get, name, @params);
		}

		/// <summary>
		///
		/// </summary>
		public override string ToString()
		{
			var sb = new StringBuilder();
			sb.Append("[target: ");
			sb.Append(this.target ?? "null");
			sb.Append("; memberName: ");
			sb.Append(this.memberName);
			sb.Append("]");
			return sb.ToString();
		}

		// private static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="target"></param>
		/// <param name="name"></param>
		/// <param name="params"></param>
		/// <returns></returns>
		private static MethodInfo FindMethod(object target, string name, object[] @params)
		{
			MethodInfo[] methods = target.GetType().GetMethods();
			foreach (var method in methods) {
				if (method.Name == name && MemberUtil.MatchesParameters(method, @params)) {
					return method;
				}
			}
			return null;
		}


		/// <summary>
		/// 
		/// </summary>
		/// <param name="target"></param>
		/// <param name="name"></param>
		/// <param name="bindingAttr"></param>
		/// <returns></returns>
		/// <exception cref="SystemNeo.Reflection.LateBinder.MissingMemberException">
		/// tB[h݂܂B
		/// </exception>
		private static object GetFieldValue(
				object target, string name, BindingFlags bindingAttr)
		{
			FieldInfo field = target.GetType().GetField(name, bindingAttr);
			if (field == null) {
				throw new MissingMemberException();
			}
			return field.GetValue(target);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="target"></param>
		/// <param name="name"></param>
		/// <param name="bindingAttr"></param>
		/// <returns></returns>
		/// <exception cref="SystemNeo.Reflection.LateBinder.MissingMemberException">
		/// vpeB݂ȂA܂͏ݐpłB
		/// </exception>
		private static object GetPropertyValueWithoutParameter(
				object target, string name, BindingFlags bindingAttr)
		{
			PropertyInfo property = target.GetType().GetProperty(name, EmptyTypeArray);
			if (property == null) {
				throw new MissingMemberException();
			}
			return property.GetValue(target, EmptyObjectArray);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="target"></param>
		/// <param name="name"></param>
		/// <returns></returns>
		// <exception cref="SystemNeo.Reflection.LateBinder.MissingMemberException">
		// tB[hvpeB݂܂B
		// </exception>
		private static object GetWithoutParameter(object target, string name)
		{
			try {
				return GetFieldValue(target, name, DefaultBinding);
			} catch (MissingMemberException) {
			}
			try {
				return GetPropertyValueWithoutParameter(target, name, DefaultBinding);
			} catch (MissingMemberException) {
			}
			throw new MissingMemberException("^ " + target.GetType().FullName
					+ " ŃtB[h܂̓vpeB " + name + " ܂B");
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private object EvalCall()
		{
			object target = (this.target as LateBinder).Eval();
			MethodInfo method = FindMethod(target, this.memberName, this.@params);
			if (method == null) {
				throw new MissingMemberException("^ " + target.GetType().FullName
						+ " Ń\bh " + this.memberName + " ܂B");
			}
			return method.Invoke(target, this.@params);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private object EvalGet()
		{
			object target = (this.target as LateBinder).Eval();
			return GetWithoutParameter(target, this.memberName);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private object EvalItem()
		{
			object target = (this.target as LateBinder).Eval();
			MethodInfo method;
			if (this.@params == null || this.@params.Length == 0) {
				try {
					return GetWithoutParameter(target, this.memberName);
				} catch (MissingMemberException) {
					method = FindMethod(target, this.memberName, EmptyObjectArray);
					if (method == null) {
						string msg = string.Format(
								"^ {0} ŃtB[hAvpeBA܂̓\bh {1} ܂B",
								target.GetType().FullName, memberName);
						throw new MissingMemberException(msg);
					}
					return method.Invoke(target, EmptyObjectArray);
				}
			}
			method = FindMethod(target, this.memberName, this.@params);
			if (method == null) {
				string msg = string.Format("^ {0} Ń\bh {1} ܂B",
						target.GetType().FullName, this.memberName);
				throw new MissingMemberException(msg);
			}
			return method.Invoke(target, @params);
		}
	}
}
