using System;
using System.ComponentModel;
using System.Globalization;
using System.Linq;
using System.Reflection;

using SystemNeo.Collections;

namespace SystemNeo.Reflection
{
	/// <summary>
	/// vpeB\܂B
	/// <see cref="System.Reflection.PropertyInfo">PropertyInfo</see> ̑Ɏgpł܂B
	/// </summary>
	public sealed class PropertyInfoNeo : ParameteredMember
	{
		#region private fields
		private readonly MethodInfoNeo[] accessors;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public override MemberAccessibility Accessibility
		{
			get {
				return this.accessors[0].Accessibility;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public PropertyAttributes Attributes
		{
			get {
				return this.AsProperty.Attributes;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool CanRead
		{
			get {
				return this.AsProperty.CanRead;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool CanWrite
		{
			get {
				return this.AsProperty.CanWrite;
			}
		}

		/// <summary>
		/// vpeB̃ftHg̒l擾܂B
		/// </summary>
		public object DefaultValue
		{
			get {
				object[] attributes
						= this.AsProperty.GetCustomAttributes(typeof(DefaultValueAttribute), false);
				if (attributes.Length == 1) {
					return ((DefaultValueAttribute)attributes[0]).Value;
				} else {
					return DBNull.Value;
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool HasDefaultValue
		{
			get {
				return (this.Attributes & PropertyAttributes.HasDefault) > 0;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override  bool IsAbstract
		{
			get {
				return this.accessors[0].IsAbstract;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public bool IsDefaultMember
		{
			get {
				object[] attributes = this.AsProperty.DeclaringType
						.GetCustomAttributes(typeof(DefaultMemberAttribute), false);
				return attributes != null && attributes.Length == 1
					&& ((DefaultMemberAttribute)attributes[0]).MemberName == this.AsProperty.Name;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsFinal
		{
			get {
				return this.accessors[0].IsFinal;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsOverloading
		{
			get {
				return this.accessors[0].IsOverloading;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsOverriding
		{
			get {
				return this.accessors[0].IsOverriding;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsSpecialName
		{
			get {
				return this.AsProperty.IsSpecialName;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsStatic
		{
			get {
				return this.accessors[0].IsStatic;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override bool IsVirtual
		{
			get {
				return this.accessors[0].IsVirtual;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public override TypeNeo MappedInterface
		{
			get {
				return this.accessors[0].MappedInterface;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public Type PropertyType
		{
			get {
				return this.AsProperty.PropertyType;
			}
		}

		// private vpeB //

		/// <summary>
		/// 
		/// </summary>
		private PropertyInfo AsProperty
		{
			get {
				return (PropertyInfo)this.member;
			}
		}

		// internal RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="property"></param>
		internal PropertyInfoNeo(PropertyInfo property) : base(property)
		{
			this.accessors = MethodInfoNeo.ConvertArray(property.GetAccessors(true));
		}

		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="properties"></param>
		/// <returns></returns>
		public static PropertyInfoNeo[] ConvertArray(PropertyInfo[] properties)
		{
			if (properties == null) {
				return null;
			} else {
				return Array.ConvertAll(properties, (p) => (PropertyInfoNeo)p);
			}
		}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="nonPublic"></param>
		/// <returns></returns>
		public MethodInfoNeo[] GetAccessors(bool nonPublic)
		{
			return this.accessors;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="nonPublic"></param>
		/// <returns></returns>
		public MethodInfoNeo GetGetMethod(bool nonPublic)
		{
			return this.AsProperty.GetGetMethod(nonPublic);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		public override ParameterInfo[] GetParameters()
		{
			return this.AsProperty.GetIndexParameters();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="nonPublic"></param>
		/// <returns></returns>
		public MethodInfoNeo GetSetMethod(bool nonPublic)
		{
			return this.AsProperty.GetSetMethod(nonPublic);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <param name="index"></param>
		/// <returns></returns>
		public object GetValue(object obj, object[] index)
		{
			return this.AsProperty.GetValue(obj, index);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <param name="invokeAttr"></param>
		/// <param name="binder"></param>
		/// <param name="index"></param>
		/// <param name="culture"></param>
		/// <returns></returns>
		public object GetValue(object obj,
				BindingFlags invokeAttr, Binder binder, object[] index, CultureInfo culture)
		{
			return this.AsProperty.GetValue(obj, invokeAttr, binder, index, culture);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="obj"></param>
		/// <param name="value"></param>
		/// <param name="invokeAttr"></param>
		/// <param name="binder"></param>
		/// <param name="index"></param>
		/// <param name="culture"></param>
		public void SetValue(object obj, object value,
				BindingFlags invokeAttr, Binder binder, object[] index, CultureInfo culture)
		{
			this.AsProperty.SetValue(obj, value, invokeAttr, binder, index, culture);
		}

		// Zq //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="property"></param>
		/// <returns></returns>
		public static implicit operator PropertyInfoNeo(PropertyInfo property)
		{
			return (PropertyInfoNeo)GetCachedInstance(property);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="property"></param>
		/// <returns></returns>
		public static explicit operator PropertyInfo(PropertyInfoNeo property)
		{
			return property == null ? null : property.AsProperty;
		}
	}
}
