using System;
using System.Collections;
using System.IO;
using System.Linq;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Text
{
	/// <summary>
	/// 
	/// </summary>
	public sealed class CollectionFormatter : CollectionFormatterBase
	{
		#region private fields
		private IFormatter elementFormatter;
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public IComparer ElementComparer { get; set; }

		/// <summary>
		/// 
		/// </summary>
		public IFormatter ElementFormatter
		{
			get {
				return this.elementFormatter;
			}
			set {
				ArgumentUtil.AssertNull(value, "ElementFormatter");
				this.elementFormatter = value;
			}
		}

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		public CollectionFormatter() : this(SimpleFormatter.Default) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="separator"></param>
		public CollectionFormatter(string separator)
				: this(SimpleFormatter.Default, null, null, separator) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="elementFormatter"></param>
		public CollectionFormatter(IFormatter elementFormatter)
		{
			ArgumentUtil.AssertNull(elementFormatter, "elementFormatter");
			this.elementFormatter = elementFormatter;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="beginBracket"></param>
		/// <param name="endBracket"></param>
		/// <param name="separator"></param>
		public CollectionFormatter(string beginBracket, string endBracket, string separator)
				: this(SimpleFormatter.Default, beginBracket, endBracket, separator) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="elementFormatter"></param>
		/// <param name="beginBracket"></param>
		/// <param name="endBracket"></param>
		/// <param name="separator"></param>
		public CollectionFormatter(
				IFormatter elementFormatter, string beginBracket, string endBracket, string separator)
				: this(elementFormatter)
		{
			this.BeginBracket = beginBracket;
			this.EndBracket = endBracket;
			this.Separator = separator;
		}

		// protected \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="value"></param>
		protected internal override void WriteToInternal(TextWriter writer, object value)
		{
			this.WriteCollection(writer, (IEnumerable)value);
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="writer"></param>
		/// <param name="e"></param>
		private void WriteCollection(TextWriter writer, IEnumerable e)
		{
			writer.Write(this.BeginBracket);
			int count = 0;
			if (this.ElementComparer != null) {
				e = e.OrderBy(this.ElementComparer);
			}
			foreach (object element in e) {
				if (count++ > 0) {
					writer.Write(this.Separator);
				}
				if (this.MaxCount > 0 && count > this.MaxCount) {
					writer.Write(this.EllipsisExpression);
					break;
				}
				this.elementFormatter.WriteTo(writer, element);
			}
			writer.Write(this.EndBracket);
		}
	}
}
