using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Text.RegularExpressions
{
	/// <summary>
	/// K\Ɋւ郁\bh񋟂܂B
	/// </summary>
	public static class RegexUtil
	{
		// public static \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="match"></param>
		/// <param name="format"></param>
		/// <returns></returns>
		public static string Format(this Match match, string format)
		{
			return DictionaryUtil.Format(new GroupDictionary(null, match), format);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="match"></param>
		/// <param name="groupName"></param>
		/// <returns>YLv`O[v݂Ȃꍇ string.Empty</returns>
		public static string Get(this Match match, string groupName)
		{
			return match.Groups[groupName].Value;
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="match"></param>
		/// <param name="groupName"></param>
		/// <returns></returns>
		public static int GetAsInt(this Match match, string groupName)
		{
			return int.Parse(Get(match, groupName));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="pattern"></param>
		/// <returns></returns>
		public static IEnumerable<string> GetGroupNamesInPattern(string pattern)
		{
			ArgumentUtil.AssertNull(pattern, "pattern");
			Regex regex = new Regex(@"\(\?(<(?<name>\w+)>|'(?<name>\w+)')");
			return Matches(regex, pattern, (m) => m.Groups["name"].Value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		/// <param name="regex"></param>
		/// <param name="input"></param>
		/// <param name="func"></param>
		/// <returns></returns>
		public static IEnumerable<T> Matches<T>(this Regex regex, string input, Func<Match, T> func) {
			ArgumentUtil.AssertNull(func, "func");
			foreach (Match m in regex.Matches(input)) {
				yield return func(m);
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="regex"></param>
		/// <param name="inputs"></param>
		/// <returns></returns>
		public static IEnumerable<Match> Matches(this Regex regex, IEnumerable<string> inputs)
		{
			foreach (string input in inputs) {
				Match m = regex.Match(input);
				if (m.Success) {
					yield return m;
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="regex"></param>
		/// <param name="input"></param>
		/// <param name="groupnum"></param>
		/// <returns></returns>
		public static IEnumerable<string> MatchValues(this Regex regex, string input, int groupnum)
		{
			return Matches(regex, input, (m) => m.Groups[groupnum].Value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="regex"></param>
		/// <param name="input"></param>
		/// <param name="groupname"></param>
		/// <returns></returns>
		public static IEnumerable<string> MatchValues(this Regex regex, string input, string groupname)
		{
			return Matches(regex, input, (m) => m.Groups[groupname].Value);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="match"></param>
		/// <returns></returns>
		public static GroupDictionary ToDictionary(this Match match)
		{
			return new GroupDictionary(null, match);
		}
	}
}
