using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Threading;

using SystemNeo;
using SystemNeo.Collections;
using SystemNeo.Collections.Generic;

namespace SystemNeo.Threading
{
	/// <summary>
	/// 
	/// </summary>
	public class ActionController : IDisposable
	{
		#region private static fields
		private const int defaultPriority = 0;
		private const int defaultThreadCount = 2;
		#endregion

		#region private fields
		private int maxThreadCount = defaultThreadCount;
		private readonly PriorityQueue<int, Entry<int>> queue
				= new PriorityQueue<int, Entry<int>>();
		private bool started;
		private Thread dequeueThread;
		private readonly IList<Thread> threads = new List<Thread>();
		private readonly AutoResetEvent @event = new AutoResetEvent(false);
		private readonly IDictionary<Thread, DelegateInvocation> currentInvocationDictionary
				= new Dictionary<Thread, DelegateInvocation>();
		#endregion

		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public int QueueLength
		{
			get {
				return this.queue.Count;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		[DefaultValue(defaultThreadCount)]
		public int MaxThreadCount
		{
			get {
				return this.maxThreadCount;
			}
			set {
				this.maxThreadCount = value;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public int ThreadCount
		{
			get {
				return this.threads.Count;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public Thread[] Threads
		{
			get {
				return this.threads.ToArray();
			}
		}

		// public Cxg //

		/// <summary>
		/// 
		/// </summary>
		public event ThreadEventHandler BeforeAction;

		/// <summary>
		/// 
		/// </summary>
		public event ThreadEventHandler AfterAction;

		/// <summary>
		/// 
		/// </summary>
		public event ThreadExceptionEventHandler OnException;

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		public void ClearQueue()
		{
			lock (this.queue) {
				this.queue.Clear();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public void Dispose()
		{
			this.ClearQueue();
			this.Stop();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="invocation"></param>
		public void Enqueue(DelegateInvocation invocation)
		{
			this.Enqueue(defaultPriority, invocation);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="priority"></param>
		/// <param name="invocation"></param>
		public void Enqueue(int priority, DelegateInvocation invocation)
		{
			ArgumentUtil.AssertNull(invocation, "invocation");
			this.EnqueueInternal(priority, invocation);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="delegate"></param>
		/// <param name="params"></param>
		public void Enqueue(Delegate @delegate, params object[] @params)
		{
			this.EnqueueDelegate(defaultPriority, @delegate, @params);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="priority"></param>
		/// <param name="delegate"></param>
		/// <param name="params"></param>
		public void Enqueue(int priority, Delegate @delegate, params object[] @params)
		{
			this.EnqueueDelegate(priority, @delegate, @params);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="action"></param>
		public void Enqueue(Action action)
		{
			this.EnqueueDelegate(defaultPriority, action);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="action"></param>
		/// <param name="priority"></param>
		public void Enqueue(int priority, Action action)
		{
			this.EnqueueDelegate(priority, action);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <param name="action"></param>
		/// <param name="arg1"></param>
		public void Enqueue<T1>(Action<T1> action, T1 arg1)
		{
			this.EnqueueDelegate(defaultPriority, action, arg1);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <param name="priority"></param>
		/// <param name="action"></param>
		/// <param name="arg1"></param>
		public void Enqueue<T1>(int priority, Action<T1> action, T1 arg1)
		{
			this.EnqueueDelegate(priority, action, arg1);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <param name="action"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		public void Enqueue<T1, T2>(Action<T1, T2> action, T1 arg1, T2 arg2)
		{
			this.EnqueueDelegate(defaultPriority, action, arg1, arg2);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <param name="priority"></param>
		/// <param name="action"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		public void Enqueue<T1, T2>(int priority, Action<T1, T2> action, T1 arg1, T2 arg2)
		{
			this.EnqueueDelegate(priority, action, arg1, arg2);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <param name="action"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		public void Enqueue<T1, T2, T3>(Action<T1, T2, T3> action, T1 arg1, T2 arg2, T3 arg3)
		{
			this.EnqueueDelegate(defaultPriority, action, arg1, arg2, arg3);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <param name="priority"></param>
		/// <param name="action"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		public void Enqueue<T1, T2, T3>(
				int priority, Action<T1, T2, T3> action, T1 arg1, T2 arg2, T3 arg3)
		{
			this.EnqueueDelegate(priority, action, arg1, arg2, arg3);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <typeparam name="T4"></typeparam>
		/// <param name="action"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		/// <param name="arg4"></param>
		public void Enqueue<T1, T2, T3, T4>(
				Action<T1, T2, T3, T4> action, T1 arg1, T2 arg2, T3 arg3, T4 arg4)
		{
			this.EnqueueDelegate(defaultPriority, action, arg1, arg2, arg3, arg4);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <typeparam name="T4"></typeparam>
		/// <param name="priority"></param>
		/// <param name="action"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		/// <param name="arg4"></param>
		public void Enqueue<T1, T2, T3, T4>(int priority,
				Action<T1, T2, T3, T4> action, T1 arg1, T2 arg2, T3 arg3, T4 arg4)
		{
			this.EnqueueDelegate(priority, action, arg1, arg2, arg3, arg4);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <typeparam name="T4"></typeparam>
		/// <param name="action"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		/// <param name="arg4"></param>
		public void Enqueue<T1, T2, T3, T4, T5>(
				Action5<T1, T2, T3, T4, T5> action, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5)
		{
			this.EnqueueDelegate(defaultPriority, action, arg1, arg2, arg3, arg4, arg5);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T1"></typeparam>
		/// <typeparam name="T2"></typeparam>
		/// <typeparam name="T3"></typeparam>
		/// <typeparam name="T4"></typeparam>
		/// <typeparam name="T5"></typeparam>
		/// <param name="priority"></param>
		/// <param name="action"></param>
		/// <param name="arg1"></param>
		/// <param name="arg2"></param>
		/// <param name="arg3"></param>
		/// <param name="arg4"></param>
		/// <param name="arg5"></param>
		public void Enqueue<T1, T2, T3, T4, T5>(int priority,
				Action5<T1, T2, T3, T4, T5> action, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5)
		{
			this.EnqueueDelegate(priority, action, arg1, arg2, arg3, arg4, arg5);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="thread"></param>
		/// <returns></returns>
		public DelegateInvocation GetCurrentInvocation(Thread thread)
		{
			ArgumentUtil.AssertNull(thread, "thread");
			lock (this) {
				return this.currentInvocationDictionary[thread];
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public void Start()
		{
			lock (this) {
				if (! this.started && this.dequeueThread == null) {
					this.started = true;
					this.dequeueThread = new Thread(this.RepeatDequeue);
					this.dequeueThread.IsBackground = true;
					this.dequeueThread.Start();
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		public void Stop()
		{
			lock (this) {
				this.started = false;
				this.@event.Set();
				for (int i = this.threads.Count - 1; i >= 0; i--) {
					this.threads[i].Abort();
				}
			}
		}

		// internal \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="thread"></param>
		/// <param name="invocation"></param>
		internal void DoBeforeAction(Thread thread, DelegateInvocation invocation)
		{
			lock (this.currentInvocationDictionary) {
				this.currentInvocationDictionary.Add(thread, invocation);
			}
			if (this.BeforeAction != null) {
				this.BeforeAction(this, new ThreadEventArgs(thread, invocation));
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="thread"></param>
		/// <param name="invocation"></param>
		internal void DoAfterAction(Thread thread, DelegateInvocation invocation)
		{
			try {
				if (this.AfterAction != null) {
					this.AfterAction(this, new ThreadEventArgs(thread, invocation));
				}
			} finally {
				lock (this) {
					this.currentInvocationDictionary.Remove(thread);
					this.threads.Remove(thread);
					this.@event.Set();
				}
			}
		}

		// private \bh //

		/// <summary>
		/// 
		/// </summary>
		private void DequeueAndInvoke()
		{
			DelegateInvocation invocation = null;
			lock (this.queue) {
				if (this.queue.Count > 0) {
					// TODO: Entry.Priority ̏Ɏo悤ɂ
					invocation = this.queue.Dequeue().Invocation;
				}
			}
			if (invocation == null) {
				// L[̏ꍇ͑ҋ@
				this.@event.WaitOne();
			} else {
				var invoker = new Invoker(this, invocation);
				var thread = new Thread(invoker.Invoke);
				lock (this.threads) {
					this.threads.Add(thread);
				}
				thread.IsBackground = true;
				thread.Start();
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="priority"></param>
		/// <param name="delegate"></param>
		/// <param name="params"></param>
		private void EnqueueDelegate(int priority, Delegate @delegate, params object[] @params)
		{
			this.EnqueueInternal(priority, new DelegateInvocation(@delegate, @params));
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="priority"></param>
		/// <param name="invocation"></param>
		private void EnqueueInternal(int priority, DelegateInvocation invocation)
		{
			lock (this.queue) {
				this.queue.Enqueue(priority, new Entry<int>(priority, invocation));
			}
			this.@event.Set();
		}
				
		/// <summary>
		/// L[Ɋi[Ă Action oAs܂B
		/// </summary>
		private void RepeatDequeue()
		{
			try {
				while (this.started) {
					if (this.threads.Count >= this.maxThreadCount) {
						// s̃Xbh̐lɒBĂꍇ͑ҋ@
						this.@event.WaitOne();
					} else {
						this.DequeueAndInvoke();
					}
				}
			} catch (Exception ex) {
				var di = new DelegateInvocation(new ThreadStart(this.RepeatDequeue));
				var e = new ThreadExceptionEventArgs(Thread.CurrentThread, di, ex);
				if (this.OnException != null) {
					this.OnException(this, e);
				}
			} finally {
				lock (this) {
					this.dequeueThread = null;
				}
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <typeparam name="T"></typeparam>
		private sealed class Entry<T> where T : IComparable<T>
		{
			// internal vpeB //

			/// <summary>
			/// 
			/// </summary>
			internal DelegateInvocation Invocation { get; private set; }

			/// <summary>
			/// ̗Dx擾܂B
			/// </summary>
			internal T Priority { get; private set; }

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="invocation"></param>
			internal Entry(T priority, DelegateInvocation invocation)
			{
				ArgumentUtil.AssertNull(invocation, "invocation");
				this.Priority = priority;
				this.Invocation = invocation;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		private sealed class Invoker
		{
			#region private fields
			private readonly ActionController contoller;
			private readonly DelegateInvocation invocation;
			#endregion

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="controller"></param>
			/// <param name="invocation"></param>
			internal Invoker(ActionController controller, DelegateInvocation invocation)
			{
				ArgumentUtil.AssertNull(controller, "controller");
				ArgumentUtil.AssertNull(invocation, "invocation");
				this.contoller = controller;
				this.invocation = invocation;
			}

			// internal \bh //

			/// <summary>
			/// 
			/// </summary>
			internal void Invoke()
			{
				Thread thread = Thread.CurrentThread;
				this.contoller.DoBeforeAction(thread, this.invocation);
				try {
					this.invocation.Invoke();
				} catch (ThreadAbortException) {
				} catch (Exception ex) {
					if (this.contoller.OnException != null) {
						this.contoller.OnException(this.contoller,
								new ThreadExceptionEventArgs(thread, this.invocation, ex));
					}
				} finally {
					this.contoller.DoAfterAction(thread, this.invocation);
				}
			}
		}
	}
}
