using System;
using System.Collections;
using System.Xml;

using SystemNeo;
using SystemNeo.Collections;

namespace SystemNeo.Xml
{
	/// <summary>
	/// XML ̑Qr鑀\܂B
	/// </summary>
	public class XmlAttributesComparer : ComparerCollection
	{
		// public vpeB //

		/// <summary>
		/// 
		/// </summary>
		public string TargetElementName { get; private set; }

		// public RXgN^ //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="elementName"></param>
		/// <param name="attributeDefinitions"></param>
		public XmlAttributesComparer(
				string elementName, params KeySortDefinition[] attributeDefinitions)
		{
			ArgumentUtil.AssertNull(elementName, "elementName");
			ArgumentUtil.AssertNull(attributeDefinitions, "attributeDefinitions");
			this.TargetElementName = elementName;
			foreach (var ksd in attributeDefinitions) {
				this.Add(new XmlAttributeComparer(ksd));
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="elementName"></param>
		/// <param name="attributeName"></param>
		public XmlAttributesComparer(string elementName, string attributeName)
			: this(elementName, new KeySortDefinition(attributeName, SortOrder.Ascending)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="elementName"></param>
		/// <param name="attributeName"></param>
		/// <param name="order"></param>
		public XmlAttributesComparer(string elementName, string attributeName, SortOrder order)
			: this(elementName, new KeySortDefinition(attributeName, order)) {}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="elementName"></param>
		/// <param name="attributeName"></param>
		/// <param name="comparer"></param>
		/// <param name="order"></param>
		public XmlAttributesComparer(
				string elementName, string attributeName, IComparer comparer, SortOrder order)
			: this(elementName, new KeySortDefinition(attributeName, comparer, order)) {}

		// public \bh //

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <returns></returns>
		public override int Compare(object x, object y)
		{
			var ex = (XmlElement)x;
			var ey = (XmlElement)y;
			if (ex.Name == ey.Name && ex.Name == this.TargetElementName) {
				return base.Compare(x, y);
			} else {
				return 0;
			}
		}

		// ^ //

		/// <summary>
		/// 
		/// </summary>
		private sealed class XmlAttributeComparer : IComparer
		{
			#region private fields
			private readonly KeySortDefinition definition;
			#endregion

			// internal RXgN^ //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="definition"></param>
			internal XmlAttributeComparer(KeySortDefinition definition)
			{
				ArgumentUtil.AssertNull(definition, "definition");
				this.definition = definition;
			}

			// private \bh //

			/// <summary>
			/// 
			/// </summary>
			/// <param name="x"></param>
			/// <param name="y"></param>
			/// <returns></returns>
			int IComparer.Compare(object x, object y)
			{
				var ex = (XmlElement)x;
				var ey = (XmlElement)y;
				string ax = ex.GetAttribute(this.definition.Key);
				string ay = ey.GetAttribute(this.definition.Key);
				int result = this.definition.Comparer.Compare(ax, ay);
				if (this.definition.Order == SortOrder.Decending) {
					result *= -1;
				}
				return result;
			}
		}
	}
}
