using System;
using System.ComponentModel;
using System.Reflection;
using SystemNeo.ComponentModel;
using NUnit.Framework;

namespace SystemNeoTest.ComponentModel.ComponentUtilTest
{
	internal class Dummy
	{
		private int defaultValueIsZero;
		private bool withoutDefaultValue;

		public bool WithoutDefaultValue
		{
			get {
				return this.withoutDefaultValue;
			}
			set {
				this.withoutDefaultValue = value;
			}
		}

		[DefaultValue(0)]
		public int DefaultValueIsZero
		{
			get {
				return this.defaultValueIsZero;
			}
			set {
				this.defaultValueIsZero = value;
			}
		}
	}

	/// <summary>
	/// GetPropertyDefaultValue(Type, string) \bh̃eXg
	/// </summary>
	[TestFixture]
	public class GetPropertyDefaultValue_Type_String
	{
		[Test]
		public void ftHglȂ()
		{
			// 
			Type targetType = typeof(Dummy);
			string propertyName = "WithoutDefaultValue";

			// s
			object result = ComponentUtil.GetPropertyDefaultValue(targetType, propertyName);

			// 
			Assert.True(result is DBNull);
		}

		[Test]
		public void ftHgl()
		{
			// 
			Type targetType = typeof(Dummy);
			string propertyName = "DefaultValueIsZero";

			// s
			object result = ComponentUtil.GetPropertyDefaultValue(targetType, propertyName);

			// 
			Assert.True(result is int);
			Assert.AreEqual(0, result);
		}
	}

	/// <summary>
	/// GetPropertyDefaultValue(PropertyInfo) \bh̃eXg
	/// </summary>
	[TestFixture]
	public class GetPropertyDefaultValue_PropertyInfo
	{
		[Test]
		public void ftHglȂ()
		{
			// 
			PropertyInfo property = typeof(Dummy).GetProperty("WithoutDefaultValue");

			// s
			object result = ComponentUtil.GetPropertyDefaultValue(property);

			// 
			Assert.True(result is DBNull);
		}

		[Test]
		public void ftHgl()
		{
			// 
			PropertyInfo property = typeof(Dummy).GetProperty("DefaultValueIsZero");

			// s
			object result = ComponentUtil.GetPropertyDefaultValue(property);

			// 
			Assert.True(result is int);
			Assert.AreEqual(0, result);
		}
	}

	/// <summary>
	/// PropertyHasDefaultValue \bh̃eXg
	/// </summary>
	[TestFixture]
	public class PropertyHasDefaultValue
	{
		[Test]
		public void ftHglȂ()
		{
			// 
			PropertyInfo property = typeof(Dummy).GetProperty("WithoutDefaultValue");
			Dummy target = new Dummy();
			target.WithoutDefaultValue = false;

			// s
			bool result = ComponentUtil.PropertyHasDefaultValue(property, target);

			// 
			Assert.False(result);
		}

		[Test]
		public void ftHglƓl()
		{
			// 
			PropertyInfo property = typeof(Dummy).GetProperty("DefaultValueIsZero");
			Dummy target = new Dummy();
			target.DefaultValueIsZero = 0;

			// s
			bool result = ComponentUtil.PropertyHasDefaultValue(property, target);

			// 
			Assert.True(result);
		}

		[Test]
		public void ftHglƈقȂ()
		{
			// 
			PropertyInfo property = typeof(Dummy).GetProperty("DefaultValueIsZero");
			Dummy target = new Dummy();
			target.DefaultValueIsZero = 1;

			// s
			bool result = ComponentUtil.PropertyHasDefaultValue(property, target);

			// 
			Assert.False(result);
		}
	}
}
