﻿using System;
using System.IO;
using SystemNeo.IO;
using NUnit.Framework;

namespace SystemNeoTest.IO.FileSystemUtilTest
{
	[TestFixture]
	public class IsInDirectory
	{
		[Test]
		public void Normal()
		{
			Assert.False(new DirectoryInfo(@"C:\"                            ).IsInDirectory(new DirectoryInfo(@"C:\"), true));
			Assert.True (new FileInfo     (@"C:\readme.txt"                  ).IsInDirectory(new DirectoryInfo(@"C:\"), true));
			Assert.True (new DirectoryInfo(@"C:\Windows"                     ).IsInDirectory(new DirectoryInfo(@"C:\"), true));
			Assert.False(new FileInfo     (@"C:\Windows\explorer.exe"        ).IsInDirectory(new DirectoryInfo(@"C:\"), true));
			Assert.False(new DirectoryInfo(@"C:\Windows\System32"            ).IsInDirectory(new DirectoryInfo(@"C:\"), true));
			Assert.False(new FileInfo     (@"C:\Windows\System32\notepad.exe").IsInDirectory(new DirectoryInfo(@"C:\"), true));

			Assert.False(new DirectoryInfo(@"C:\"                            ).IsInDirectory(new DirectoryInfo(@"C:\"), false));
			Assert.True (new FileInfo     (@"C:\readme.txt"                  ).IsInDirectory(new DirectoryInfo(@"C:\"), false));
			Assert.True (new DirectoryInfo(@"C:\Windows"                     ).IsInDirectory(new DirectoryInfo(@"C:\"), false));
			Assert.True (new FileInfo     (@"C:\Windows\explorer.exe"        ).IsInDirectory(new DirectoryInfo(@"C:\"), false));
			Assert.True (new DirectoryInfo(@"C:\Windows\System32"            ).IsInDirectory(new DirectoryInfo(@"C:\"), false));
			Assert.True (new FileInfo     (@"C:\Windows\System32\notepad.exe").IsInDirectory(new DirectoryInfo(@"C:\"), false));

			Assert.False(new DirectoryInfo(@"C:\"                            ).IsInDirectory(new DirectoryInfo(@"C:\Windows"), true));
			Assert.False(new FileInfo     (@"C:\readme.txt"                  ).IsInDirectory(new DirectoryInfo(@"C:\Windows"), true));
			Assert.False(new DirectoryInfo(@"C:\Windows"                     ).IsInDirectory(new DirectoryInfo(@"C:\Windows"), true));
			Assert.True (new FileInfo     (@"C:\Windows\explorer.exe"        ).IsInDirectory(new DirectoryInfo(@"C:\Windows"), true));
			Assert.True (new DirectoryInfo(@"C:\Windows\System32"            ).IsInDirectory(new DirectoryInfo(@"C:\Windows"), true));
			Assert.False(new FileInfo     (@"C:\Windows\System32\notepad.exe").IsInDirectory(new DirectoryInfo(@"C:\Windows"), true));

			Assert.False(new DirectoryInfo(@"C:\"                            ).IsInDirectory(new DirectoryInfo(@"C:\Windows"), false));
			Assert.False(new FileInfo     (@"C:\readme.txt"                  ).IsInDirectory(new DirectoryInfo(@"C:\Windows"), false));
			Assert.False(new DirectoryInfo(@"C:\Windows"                     ).IsInDirectory(new DirectoryInfo(@"C:\Windows"), false));
			Assert.True (new FileInfo     (@"C:\Windows\explorer.exe"        ).IsInDirectory(new DirectoryInfo(@"C:\Windows"), false));
			Assert.True (new DirectoryInfo(@"C:\Windows\System32"            ).IsInDirectory(new DirectoryInfo(@"C:\Windows"), false));
			Assert.True (new FileInfo     (@"C:\Windows\System32\notepad.exe").IsInDirectory(new DirectoryInfo(@"C:\Windows"), false));

			Assert.False(new DirectoryInfo(@"C:\"                            ).IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), true));
			Assert.False(new FileInfo     (@"C:\readme.txt"                  ).IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), true));
			Assert.False(new DirectoryInfo(@"C:\Windows"                     ).IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), true));
			Assert.False(new FileInfo     (@"C:\Windows\explorer.exe"        ).IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), true));
			Assert.False(new DirectoryInfo(@"C:\Windows\System32"            ).IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), true));
			Assert.True (new FileInfo     (@"C:\Windows\System32\notepad.exe").IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), true));

			Assert.False(new DirectoryInfo(@"C:\"                            ).IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), false));
			Assert.False(new FileInfo     (@"C:\readme.txt"                  ).IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), false));
			Assert.False(new DirectoryInfo(@"C:\Windows"                     ).IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), false));
			Assert.False(new FileInfo     (@"C:\Windows\explorer.exe"        ).IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), false));
			Assert.False(new DirectoryInfo(@"C:\Windows\System32"            ).IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), false));
			Assert.True (new FileInfo     (@"C:\Windows\System32\notepad.exe").IsInDirectory(new DirectoryInfo(@"C:\Windows\System32"), false));
		}
	}
}
