using System;
using SystemNeo.Reflection;
using NUnit.Framework;

namespace SystemNeoTest.Reflection.TypeExTest
{
	[TestFixture]
	public class CanBox
	{
		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void null_1()
		{
			// s
			bool result = TypeNeo.CanBox(null, typeof(string));
		}

		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void null_2()
		{
			// s
			bool result = TypeNeo.CanBox(typeof(string), null);
		}

		[Test]
		public void object_l^()
		{
			// s
			bool result = TypeNeo.CanBox(typeof(object), typeof(int));

			// 
			Assert.True(result);
		}

		[Test]
		public void object_NX()
		{
			// s
			bool result = TypeNeo.CanBox(typeof(object), typeof(string));

			// 
			Assert.False(result);
		}

		[Test]
		public void ValueType_l^()
		{
			// s
			bool result = TypeNeo.CanBox(typeof(ValueType), typeof(int));

			// 
			Assert.IsTrue(result);
		}

		[Test]
		public void Enum_񋓑()
		{
			// s
			bool result = TypeNeo.CanBox(typeof(Enum), typeof(DayOfWeek));

			// 
			Assert.True(result);
		}

		[Test]
		public void interface_Ăl^()
		{
			// s
			bool result = TypeNeo.CanBox(typeof(IConvertible), typeof(int));

			// 
			Assert.True(result);
		}

		[Test]
		public void interface_ĂȂl^()
		{
			// s
			bool result = TypeNeo.CanBox(typeof(System.Collections.IList), typeof(int));

			// 
			Assert.False(result);
		}
	}

	[TestFixture]
	public class CreateInstance
	{
		[Test]
		public void publicRXgN^()
		{
			// 
			TypeNeo te = typeof(Random);

			// s
			object result = te.CreateInstance();

			// 
			Assert.AreSame(typeof(Random), result.GetType());
		}

		[Test]
		public void internalRXgN^()
		{
			// 
			TypeNeo te = typeof(Internal0);

			// s
			object result = te.CreateInstance();

			// 
			Assert.AreSame(typeof(Internal0), result.GetType());
		}

		[Test]
		public void privateRXgN^()
		{
			// 
			TypeNeo te = typeof(Private0);

			// s
			object result = te.CreateInstance();

			// 
			Assert.Null(result);
		}

		[Test]
		public void RXgN^Ȃ()
		{
			// 
			TypeNeo te = typeof(Internal1);  // p[^O̃RXgN^ȂNX
			
			// s
			object result = te.CreateInstance();

			// 
			Assert.Null(result);
		}
	}

	[TestFixture]
	public class CreateInstance_Object
	{
		[Test]
		public void publicRXgN^()
		{
			// 
			TypeNeo te = typeof(string);

			// s
			object result = te.CreateInstance(new char[] {'A', 'B', 'C'});

			// 
			Assert.AreEqual("ABC", result);
		}

		[Test]
		public void internalRXgN^()
		{
			// 
			TypeNeo te = typeof(Internal1);

			// s
			object result = te.CreateInstance("name");

			// 
			Assert.AreSame(typeof(Internal1), result.GetType());
		}

		[Test]
		public void privateRXgN^()
		{
			// 
			TypeNeo te = typeof(Private1);

			// s
			object result = te.CreateInstance("name");

			// 
			Assert.Null(result);
		}

		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void @null()
		{
			// 
			TypeNeo te = typeof(string);

			// s
			object result = te.CreateInstance(null);
		}

		[Test]
		public void ^̕sv()
		{
			// 
			TypeNeo te = typeof(string);
			
			// s
			object result = te.CreateInstance(DateTime.Now);

			// 
			Assert.Null(result);
		}
	}

	[TestFixture]
	public class CreateInstance_Object_Object
	{
		[Test]
		public void publicRXgN^()
		{
			// 
			TypeNeo te = typeof(string);

			// s
			object result = te.CreateInstance('A', 2);

			// 
			Assert.AreEqual("AA", result);
		}

		[Test]
		public void internalRXgN^()
		{
			// 
			TypeNeo te = typeof(Internal2);

			// s
			object result = te.CreateInstance("name", "value");

			// 
			Assert.AreSame(typeof(Internal2), result.GetType());
		}

		[Test]
		public void privateRXgN^()
		{
			// 
			TypeNeo te = typeof(Private2);

			// s
			object result = te.CreateInstance("name", "value");

			// 
			Assert.Null(result);
		}

		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void null_1()
		{
			// 
			TypeNeo te = typeof(Internal2);

			// s
			object result = te.CreateInstance(null, "value");
		}

		[Test][ExpectedException(typeof(ArgumentNullException))]
		public void null_2()
		{
			// 
			TypeNeo te = typeof(Internal2);

			// s
			object result = te.CreateInstance("name", null);
		}

		[Test]
		public void ^̕sv()
		{
			// 
			TypeNeo te = typeof(string);
			
			// s
			object result = te.CreateInstance('A', 2L);     // int ̂Ƃ long n

			// 
			Assert.Null(result);
		}
	}

	internal class Internal0
	{
		internal Internal0() {}
	}

	internal class Internal1
	{
		internal Internal1(string name) {}
	}

	internal class Internal2
	{
		internal Internal2(string name, string value) {}
	}

	internal class Private0
	{
		private Private0() {}
	}

	internal class Private1
	{
		private Private1(string name) {}
	}

	internal class Private2
	{
		private Private2(string name, string value) {}
	}
}
