/*-
 * Copyright (c) 2014 Yuichi Watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _AML_COMPAT_H
#define _AML_COMPAT_H

#include <common/calc.h>
#include <common/string.h>
#include <core/assert.h>
#include <core/mm.h>
#include <io.h>
#include "aml_common.h"

#define bcopy(src, dest, len)\
	memcpy(dest, src, len)
#define bzero(dest, len)\
	memset(dest, 0, len)

#define ROUNDUP_UNIT 4
#define roundup ROUND_UP

#define _DIAGASSERT ASSERT

#define OsdIn8(arg) 0xff
#define OsdIn16(arg) 0xffff
#define OsdIn32(arg) 0xffffffff
#define OsdOut8(arg1, arg2)
#define OsdOut16(arg1, arg2)
#define OsdOut32(arg1, arg2)
#define OsdWritePciCfgByte(arg1, arg2, arg3, arg4)
#define OsdWritePciCfgWord(arg1, arg2, arg3, arg4)
#define OsdWritePciCfgDword(arg1, arg2, arg3, arg4)

static inline void
OsdReadPciCfgByte(u_int32_t bus, u_int32_t devfunc,
		  vm_offset_t offset, u_int8_t *valuep)
{
	*valuep = 0xff;
}

static inline void
OsdReadPciCfgWord(u_int32_t bus, u_int32_t devfunc,
		  vm_offset_t offset, u_int16_t *valuep)
{
	*valuep = 0xffff;
}

static inline void
OsdReadPciCfgDword(u_int32_t bus, u_int32_t devfunc,
		  vm_offset_t offset, u_int32_t *valuep)
{
	*valuep = 0xffffffff;
}

/*
 * AML seems to access reserved areas of RAM.
 */
static inline void
OsdMapMemory(void *addr, int len, void **vaddr)
{
	*vaddr = mapmem(MAPMEM_HPHYS | MAPMEM_WRITE, (phys_t)addr, len);
}

static inline void
OsdUnMapMemory(void *vaddr, int len)
{
	unmapmem(vaddr, len);
}

void
qsort(void *a, size_t n, size_t es, int (*cmp)(const void *, const void *));

#endif /* _AML_COMPAT_H */
