/**
 * @file pll.h
 *
 *  @date 2010/08/08
 *  @author: takemasa
 *  @brief PLL制御関数のヘッダファイル
 */

#ifndef PLL_H_
#define PLL_H_
/**
 * @brief PLLのクロックソース。 initPLL0に渡して使う。
 */
typedef enum { eIrc, eMainOsc, eRtcOsc} pllClockSource_type;

/**
 * @param clkSrc PLLのソースとなるクロック。eIrc, eMainOsc, eRtcOscのうち一つを指定する。
 * @param isMainOsc20MHzMore メイン発振器の周波数が20MHz以上なら真を渡す
 * @param M 梯倍比を決める整数。6から512が許される。
 * @param N PLLのリファレンス入力の分周比を決める整数。1から32が許される
 * @param cpuClkDiv PLLの出力の分周器。1/cpuClkDivになる。0,1,2は禁止。
 * @details
 * PLL0の周波数を設定する。クロックソースとなる発振器、その周波数、PLLのデバイダ、PLL後のデバイダを
 * 指定する。生成するクロックの周波数は以下の通りとなる。CCLKがCPUのコアクロックである。
 * @code
 * PLLCLK = (2 × M × FIN) / N
 * CCLK = PLLCLK / cpuClkDiv
 * @endcode
 * ペリフェラルはさらにCCLKを分周して使う。PLLに関しては次のようなパラメタが定められている
 * - 入力は32kHz - 50MHz (UM10360, section 5.1)
 * - PLL出力は 275MHz - 550MHz (同上)
 * - CCLKは最大100MHz (データシート)
 */
void initPLL0(
		pllClockSource_type 	clkSrc,
		unsigned int 			isMainOsc20MHzMore,
		unsigned int			N,
		unsigned int			M,
		unsigned int			cpuClkDiv
	);

#endif /* PLL_H_ */
