	.text
	.align 2
	.code 16
	.global _start
	.extern _master_stack
	.extern main
	.extern _bss_end, _bss_start
	.type _start, function

_start:
	/*
	 * MSPと特権状態の設定
	 *
	 * controlレジスタに0b00を代入し、ハンドラモード、スレッドモードの双方で
	 * 1. MSPを使い
	 * 2. 特権状態を維持する。
	 * なお、以下のコードはスレッドモードかつ特権状態（つまりリセット後の状態）でしか
	 * 正常に動作しない。
	 *
	 * なお、CORTEX-M3は、リセット後にMSPを自動的に設定するために、以下のコードは
	 * 冗長であるといえる。ただし、SRAMで動かすには何らかの方法でスタックポインタの
	 * 設定を行うことが必要になる。以下のコードはそのためのものである。
	 */
	ldr		r0,=_data_start_lma	/* _data_start_lmaが0ならSRAM上で動作している */
	cbnz	r0,master_stack_exit	/* 非0ならROM実行なのでStackは初期化しない */
	mov   	r0, #0  				/* MSPを有効にし、常に特権状態とする  */
	msr   	control, r0			/* CONTROLは特殊レジスタなのでMSRで転送する */
	isb               	      	/* 命令同期バリア。control の操作後に必要 */
	ldr  	r0,=_master_stack		/* スタックポインタの初期値はSRAMの最上位番地 + 1*/
	msr  	msp, r0				/* MSPは特殊レジスタなので MSR命令で転送する */
	b		init_bss				/* SRAM実行なので .dataの初期化は不要 */
master_stack_exit:

	 /*
	 * .data領域の初期化
	 * flash上のプログラムを実行する場合、.data領域はだれも初期化してくれない。
	 *  一方で、.dataはCの初期化大域変数を置く場所なので、main()実行前に初期化
	 * しなければならない。以下のコードは、この初期化を行う。
	 * _data_startと_data_endは、LDファイルが提供するアドレス・シンボルで、それぞれ
	 * .data領域の開始アドレスと終了アドレスを示す。_data_start_lmaはLDファイルが提供
	 * するアドレスで、初期値が格納されているFlashの先頭番地である。
	 */
	ldr		r3,=_data_start_lma
	ldr		r0,=_data_start
	ldr		r1,=_data_end
	sub		r1,r0					/* r1 = loopcounter */
loop_data:
	cbz		r1, loop_data_exit		/* ループカウンターが0になるまで繰り返す */
	ldrb	r2, [r3]
	strb	r2, [r0]
	add		r0, #1
	add    r3, #1
	sub		r1,#1					/* loopcounter -- */
	b		loop_data
loop_data_exit:

	 /*
	 * .vector領域の初期化
	 * flash上のプログラムを実行する場合も、例外ベクトルはSRAM上におく。このとき、
	 * SRAM上のベクトル領域はだれも初期化してくれない。
	 *  一方で、例外ベクトルは、main()実行前に初期化しなければならない。以下のコードは、この初期化を行う。
	 * _vector_startと_vector_endは、LDファイルが提供するアドレス・シンボルで、それぞれ
	 * .vector領域の開始アドレスと終了アドレスを示す。_vector_start_lmaはLDファイルが提供
	 * するアドレスで、リセット時にベクトルが格納されているFlashの先頭番地である。
	 */
	ldr		r3,=_vector_start_lma
	ldr		r0,=_vector_start
	ldr		r1,=_vector_end
	sub		r1,r0					/* r1 = loopcounter */
loop_vector:
	cbz		r1, loop_vector_exit		/* ループカウンターが0になるまで繰り返す */
	ldrb	r2, [r3]
	strb	r2, [r0]
	add		r0, #1
	add    r3, #1
	sub		r1,#1					/* loopcounter -- */
	b		loop_vector
loop_vector_exit:
	 /*
	 * .bss領域のゼロクリア
	 * GDBからプログラムをロードする場合、.bss領域はだれもクリアしてくれない。
	 *  一方で、.bssはCの未初期化大域変数を置く場所なので、main()実行前にゼロフィル
	 * しなければならない。以下のコードは、このゼロフィルを行う。
	 * _bss_startと_bss_endは、LDファイルが提供するアドレス・シンボルで、それぞれ
	 * .bss領域の開始アドレスと終了アドレスを示す。
	 */
init_bss:
	mov		r2, #0
	ldr		r0,=_bss_start
	ldr		r1,=_bss_end
	sub		r1,r0					/* r1 = loopcounter */
loop_bss:
	cbz		r1, loop_bss_exit		/* ループカウンターが0になるまで繰り返す */
	strb	r2, [r0]
	add		r0, #1
	sub		r1,#1					/* loopcounter -- */
	b		loop_bss
loop_bss_exit:



	bl		main					/* main() 関数を呼ぶ */



_end:
	b _end						/* main() から戻ってきたら無限ループ */
