/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.bind;

import hidden.org.apache.jackrabbit.webdav.DavException;
import hidden.org.apache.jackrabbit.webdav.bind.BindConstants;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.apache.jackrabbit.webdav.xml.ElementIterator;
import hidden.org.apache.jackrabbit.webdav.xml.XmlSerializable;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParentElement
implements XmlSerializable {
    private static Logger log = LoggerFactory.getLogger(ParentElement.class);
    private final String href;
    private final String segment;

    public ParentElement(String href, String segment) {
        this.href = href;
        this.segment = segment;
    }

    public String getHref() {
        return this.href;
    }

    public String getSegment() {
        return this.segment;
    }

    public static ParentElement createFromXml(Element root) throws DavException {
        if (!DomUtil.matches(root, "parent", BindConstants.NAMESPACE)) {
            log.warn("DAV:paret element expected");
            throw new DavException(400);
        }
        String href = null;
        String segment = null;
        ElementIterator it = DomUtil.getChildren(root);
        while (it.hasNext()) {
            Element elt = it.nextElement();
            if (DomUtil.matches(elt, "segment", BindConstants.NAMESPACE)) {
                if (segment == null) {
                    segment = DomUtil.getText(elt);
                    continue;
                }
                log.warn("unexpected multiple occurence of DAV:segment element");
                throw new DavException(400);
            }
            if (DomUtil.matches(elt, "href", BindConstants.NAMESPACE)) {
                if (href == null) {
                    href = DomUtil.getText(elt);
                    continue;
                }
                log.warn("unexpected multiple occurence of DAV:href element");
                throw new DavException(400);
            }
            log.warn("unexpected element " + elt.getLocalName());
            throw new DavException(400);
        }
        if (href == null) {
            log.warn("DAV:href element expected");
            throw new DavException(400);
        }
        if (segment == null) {
            log.warn("DAV:segment element expected");
            throw new DavException(400);
        }
        return new ParentElement(href, segment);
    }

    public Element toXml(Document document) {
        Element parentElt = DomUtil.createElement(document, "parent", BindConstants.NAMESPACE);
        Element hrefElt = DomUtil.createElement(document, "href", BindConstants.NAMESPACE, this.href);
        Element segElt = DomUtil.createElement(document, "segment", BindConstants.NAMESPACE, this.segment);
        parentElt.appendChild(hrefElt);
        parentElt.appendChild(segElt);
        return parentElt;
    }
}

