/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.HTABrowserLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LauncherUtils {
    static Log log = LogFactory.getLog(LauncherUtils.class);
    static final Pattern JAVA_STYLE_UNC_URL = Pattern.compile("^file:////([^/]+/.*)$");

    protected static File createCustomProfileDir(String sessionId) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String customProfileDirParent = tmpDir.exists() && tmpDir.isDirectory() ? tmpDir.getAbsolutePath() : ".";
        File customProfileDir = new File(customProfileDirParent + "/customProfileDir" + sessionId);
        if (customProfileDir.exists()) {
            LauncherUtils.recursivelyDeleteDir(customProfileDir);
        }
        customProfileDir.mkdir();
        return customProfileDir;
    }

    public static void recursivelyDeleteDir(File customProfileDir) {
        if (customProfileDir == null || !customProfileDir.exists()) {
            return;
        }
        Delete delete = new Delete();
        delete.setProject(new Project());
        delete.setDir(customProfileDir);
        delete.setFailOnError(true);
        delete.execute();
    }

    public static void deleteTryTryAgain(File dir, int tries) {
        try {
            LauncherUtils.recursivelyDeleteDir(dir);
        }
        catch (BuildException e) {
            if (tries > 0) {
                AsyncExecute.sleepTight(2000L);
                LauncherUtils.deleteTryTryAgain(dir, tries - 1);
            }
            throw e;
        }
    }

    protected static File makeProxyPAC(File parentDir, int port) throws FileNotFoundException {
        return LauncherUtils.makeProxyPAC(parentDir, port, true);
    }

    protected static File makeProxyPAC(File parentDir, int port, boolean proxySeleniumTrafficOnly) throws FileNotFoundException {
        return LauncherUtils.makeProxyPAC(parentDir, port, proxySeleniumTrafficOnly, System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort"), System.getProperty("http.nonProxyHosts"), SeleniumServer.isAvoidProxy());
    }

    public static File makeProxyPAC(File parentDir, int port, boolean proxySeleniumTrafficOnly, String configuredProxy, String proxyPort, String nonProxyHosts, boolean avoidProxy) throws FileNotFoundException {
        if (!avoidProxy) {
            proxySeleniumTrafficOnly = false;
        }
        File proxyPAC = new File(parentDir, "proxy.pac");
        PrintStream out = new PrintStream(new FileOutputStream(proxyPAC));
        String defaultProxy = "DIRECT";
        if (configuredProxy != null) {
            defaultProxy = "PROXY " + configuredProxy;
            if (proxyPort != null) {
                defaultProxy = defaultProxy + ":" + proxyPort;
            }
        }
        out.println("function FindProxyForURL(url, host) {");
        if (proxySeleniumTrafficOnly) {
            out.println("    if(shExpMatch(url, '*/selenium-server/*')) {");
        }
        out.println("        return 'PROXY localhost:" + Integer.toString(port) + "; " + defaultProxy + "';");
        if (proxySeleniumTrafficOnly) {
            if (nonProxyHosts != null && nonProxyHosts.trim().length() > 0) {
                String[] hosts;
                for (String host : hosts = nonProxyHosts.split("\\|")) {
                    out.println("    } else if (shExpMatch(host, '" + host + "')) {");
                    out.println("        return 'DIRECT';");
                }
            }
            if (configuredProxy != null) {
                out.println("    } else {");
                out.println("        return '" + defaultProxy + "';");
            }
            out.println("    }");
        }
        out.println("}");
        out.close();
        return proxyPAC;
    }

    public static String stripStartURL(String url) {
        try {
            URL u = new URL(url);
            String path = u.getPath();
            if (path != null && !"".equals(path) && !path.endsWith("/")) {
                log.warn("It looks like your baseUrl (" + url + ") is pointing to a file, not a directory (it doesn't end with a /).  We're going to have to strip off the last part of the pathname.");
            }
            return u.getProtocol() + "://" + u.getAuthority();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getQueryString(String url) {
        try {
            URL u = new URL(url);
            String query = u.getQuery();
            return query == null ? "" : query;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getDefaultHTMLSuiteUrl(String browserURL, String suiteUrl, boolean multiWindow, int serverPort, String defaultLogLevel) {
        String url = LauncherUtils.stripStartURL(browserURL);
        String resultsUrl = serverPort == 0 ? "../postResults" : "http://localhost:" + serverPort + "/selenium-server/postResults";
        return url + "/selenium-server/core/TestRunner.html?auto=true" + "&multiWindow=" + multiWindow + "&defaultLogLevel=" + defaultLogLevel + "&baseUrl=" + LauncherUtils.urlEncode(browserURL) + "/selenium-server/tests/" + "&resultsUrl=" + resultsUrl + "&test=" + LauncherUtils.urlEncode(suiteUrl);
    }

    protected static String getDefaultRemoteSessionUrl(String startURL, String sessionId, boolean multiWindow, int serverPort) {
        String url = LauncherUtils.stripStartURL(startURL);
        url = url + "/selenium-server/core/RemoteRunner.html?sessionId=" + sessionId + "&multiWindow=" + multiWindow + "&baseUrl=" + LauncherUtils.urlEncode(startURL) + "&debugMode=" + SeleniumServer.isBrowserSideLogEnabled();
        if (serverPort != 0) {
            url = url + "&driverUrl=http://localhost:" + serverPort + "/selenium-server/driver/";
        }
        return url;
    }

    public static String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected static File extractHTAFile(File dir, int port, String resourceFile, String outFile) {
        InputStream input = HTABrowserLauncher.class.getResourceAsStream(resourceFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        File hta = new File(dir, outFile);
        try {
            FileWriter fw = new FileWriter(hta);
            String line = br.readLine();
            fw.write(line);
            fw.write(10);
            fw.write("<base href=\"http://localhost:" + port + "/selenium-server/core/\">");
            while ((line = br.readLine()) != null) {
                fw.write(line);
                fw.write(10);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hta;
    }

    public static boolean isScriptFile(File aFile) {
        char[] firstTwoChars = new char[2];
        try {
            FileReader reader = new FileReader(aFile);
            int charsRead = reader.read(firstTwoChars);
            if (2 != charsRead) {
                return false;
            }
            return firstTwoChars[0] == '#' && firstTwoChars[1] == '!';
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void copySingleFile(File sourceFile, File destFile) {
        Project p = new Project();
        Copy c = new Copy();
        c.setProject(p);
        c.setTofile(destFile);
        FileSet fs = new FileSet();
        fs.setFile(sourceFile);
        c.addFileset(fs);
        c.execute();
    }

    protected static void copyDirectory(File source, File dest) {
        Project p = new Project();
        Copy c = new Copy();
        c.setProject(p);
        c.setTodir(dest);
        FileSet fs = new FileSet();
        fs.setDir(source);
        c.addFileset(fs);
        c.execute();
    }

    protected static boolean copyDirectory(File source, String suffix, File dest) {
        boolean result = false;
        try {
            Project p = new Project();
            Copy c = new Copy();
            c.setProject(p);
            c.setTodir(dest);
            FileSet fs = new FileSet();
            fs.setDir(source);
            if (null != suffix) {
                fs.setIncludes("*" + suffix);
            }
            c.addFileset(fs);
            c.execute();
            result = !dest.exists() ? dest.mkdirs() : true;
        }
        catch (SecurityException se) {
            log.warn("Could not copy the specified directory files", se);
            result = false;
        }
        return result;
    }

    protected static void generatePacAndPrefJs(File customProfileDir, int port, ProxySetting proxySetting, String homePage, boolean changeMaxConnections, RemoteControlConfiguration configuration) throws FileNotFoundException {
        if (proxySetting == ProxySetting.PROXY_SELENIUM_TRAFFIC_ONLY && !SeleniumServer.isAvoidProxy()) {
            proxySetting = ProxySetting.PROXY_EVERYTHING;
        }
        File prefsJS = new File(customProfileDir, "prefs.js");
        PrintStream out = new PrintStream(new FileOutputStream(prefsJS, true));
        out.println("user_pref('browser.shell.checkDefaultBrowser', false);");
        if (proxySetting != ProxySetting.NO_PROXY) {
            boolean proxySeleniumTrafficOnly = proxySetting == ProxySetting.PROXY_SELENIUM_TRAFFIC_ONLY;
            File proxyPAC = LauncherUtils.makeProxyPAC(customProfileDir, port, proxySeleniumTrafficOnly);
            out.println("user_pref('network.proxy.type', 2);");
            out.println("user_pref('network.proxy.autoconfig_url', '" + LauncherUtils.pathToBrowserURL(proxyPAC.getAbsolutePath()) + "');");
        }
        out.println("user_pref('network.http.phishy-userpass-length', 255);");
        out.println("user_pref('browser.allowpopups', true);");
        out.println("user_pref('dom.disable_open_during_load', false);");
        out.println("user_pref('dom.max_script_run_time', " + configuration.getTimeoutInSeconds() + ");");
        out.println("user_pref('dom.max_chrome_script_run_time', " + configuration.getTimeoutInSeconds() + ");");
        out.println("user_pref('browser.link.open_external', 2);");
        out.println("user_pref('browser.link.open_newwindow', 2);");
        if (homePage != null) {
            out.println("user_pref('startup.homepage_override_url', '" + homePage + "');");
            out.println("user_pref('browser.startup.homepage', '" + homePage + "');");
            out.println("user_pref('startup.homepage_welcome_url', '');");
            out.println("user_pref('browser.startup.page', 1);");
        }
        out.println("user_pref('security.warn_submit_insecure', false);");
        out.println("user_pref('security.warn_submit_insecure.show_once', false);");
        out.println("user_pref('security.warn_entering_secure', false);");
        out.println("user_pref('security.warn_entering_secure.show_once', false);");
        out.println("user_pref('security.warn_entering_weak', false);");
        out.println("user_pref('security.warn_entering_weak.show_once', false);");
        out.println("user_pref('security.warn_leaving_secure', false);");
        out.println("user_pref('security.warn_leaving_secure.show_once', false);");
        out.println("user_pref('security.warn_viewing_mixed', false);");
        out.println("user_pref('security.warn_viewing_mixed.show_once', false);");
        out.println("user_pref('browser.cache.disk.enable', false);");
        out.println("user_pref('browser.cache.memory.enable', true);");
        out.println("user_pref('signon.rememberSignons', false);");
        out.println("user_pref('browser.EULA.3.accepted', true);");
        out.println("user_pref('browser.EULA.override', true);");
        out.println("user_pref('app.update.auto', false);");
        out.println("user_pref('app.update.enabled', false);");
        out.println("user_pref('extensions.update.enabled', false);");
        out.println("user_pref('browser.search.update', false);");
        out.println("user_pref('browser.safebrowsing.enabled', false);");
        if (changeMaxConnections) {
            out.println("user_pref('network.http.max-connections', 256);");
            out.println("user_pref('network.http.max-connections-per-server', 256);");
            out.println("user_pref('network.http.max-persistent-connections-per-proxy', 256);");
            out.println("user_pref('network.http.max-persistent-connections-per-server', 256);");
        }
        out.close();
    }

    private static String pathToBrowserURL(String path) {
        if (path == null) {
            return null;
        }
        String url = new File(path).toURI().toString();
        Matcher m = JAVA_STYLE_UNC_URL.matcher(url);
        if (m.find()) {
            url = "file://///";
            url = url + m.group(1);
        }
        return url;
    }

    public static Map<String, String> parseDictionary(String data, Pattern pattern, boolean reverse) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : data.split("\n")) {
            String value;
            String name;
            Matcher m = pattern.matcher(line);
            if (!m.find()) continue;
            if (reverse) {
                name = m.group(2);
                value = m.group(1);
            } else {
                name = m.group(1);
                value = m.group(2);
            }
            map.put(name, value);
        }
        return map;
    }

    public static Map<String, String> parseDictionary(String data, Pattern pattern) {
        return LauncherUtils.parseDictionary(data, pattern, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ProxySetting {
        NO_PROXY,
        PROXY_SELENIUM_TRAFFIC_ONLY,
        PROXY_EVERYTHING;

    }
}

