# -*- coding: utf-8 -*-
#
# Copyright (C) 2007-2009 Edgewall Software
# All rights reserved.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at http://trac.edgewall.org/wiki/TracLicense.
#
# This software consists of voluntary contributions made by many
# individuals. For the exact contribution history, see the revision
# history and logs, available at http://trac.edgewall.org/log/.

"""Utilities for text translation with gettext.

Currently (for version 0.11) the functions here are noops, and only used to
flag localizable strings as such.
"""

__all__ = ['gettext', 'ngettext', 'gettext_noop', 'ngettext_noop']

def gettext_noop(string, **kwargs):
    retval = string
    if kwargs:
        retval %= kwargs
    return retval
def gettext_qhack(string, **kwargs):
    retval = _qhack(string)
    if kwargs:
        retval %= kwargs
    return retval
N_ = gettext_qhack
gettext = _ = gettext_qhack

def ngettext_noop(singular, plural, num, **kwargs):
    if num == 1:
        retval = singular
    else:
        retval = plural
    kwargs.setdefault('num', num)
    return retval % kwargs
def ngettext_qhack(singular, plural, num, **kwargs):
    if num == 1:
        retval = singular
    else:
        retval = plural
    retval = _qhack(retval)
    kwargs.setdefault('num', num)
    return retval % kwargs
ngettext = ngettext_qhack

def _qhack(key):
    global _tbl
    if key in _tbl:
        return unicode(_tbl[key], 'utf-8')
    else:
        return key


_tbl = {
' (descending)': '(降順)',
'"%(subject)s" was already added to group "%(group)s"': '%(subject)s はすでにグループ %(group)s に追加されています',
'"%(value)s" is not a valid value for the %(name)s field.': '"%(value)s" は %(name)s への値として無効です。', 
'%(age)i second': '%(age)i 秒',
'%(age)i seconds': '%(age)i 秒',
'%(attachment)s (delete)': '%(attachment)s (削除)',
'%(date)s in Timeline': 'タイムラインでの %(date)s',
'%(groupvalue)s %(groupname)s tickets matching %(query)s': '%(query)s にマッチする %(groupname)s が %(groupvalue)s のチケット',
'%(kind)s from': '%(kind)s元:',
'%(last)d of %(total)d': '%(total)d 個中 %(last)d',
'%(meg)sNo node %(path)s at revision %(rev)s': '%(msg)sリビジョン %(rev)s では %(path)s というノードは存在しません',
'%(name)s: Ticket Query': '%(name)s: チケットクエリ',
'%(perm)s privileges are required to perform this operation': 'この操作を行うには %(perm)s 権限が必要です',
'%(perm)s privileges are required to perform this operation on %(resource)s': '%(resource)s に対して、この操作を行うには %(perm)s 権限が必要です',
'%(size)s bytes': '%(size)s バイト',
'%(start)d - %(stop)d of %(total)d': '%(total)d 個中 %(start)d - %(stop)d',
'(The file is empty)': '(このファイルは空です)',
'%(type)s %(name)s already exists': '%(type)s %(name)s は既に存在します。',
'%(type)s %(name)s does not exist.': '%(type)s %(name)s は存在しません。',
'(%(count)s match)': '(%(count)s 件のマッチ)',
'(%(count)s matches)': '(%(count)s 件のマッチ)', 
'(%(result0)d - %(result1)d of %(resultall)d)': '(%(resultall)d 件中 %(result0)d - %(result1)d 件目)',
'(blank page)': '(空白のページ)',
'(IP: %(ipnr)s)': 'IP アドレス: %(ipnr)s',
'(log)': '(リビジョンログ)',
'(more results for this group on next page)': '(このグループの検索結果の続きが次のページにあります)',
'(multiple changes)': '(複数のバージョン間の更新)',
'(No files)': '(ファイルなし)',
'(No matches)': '(0 件のマッチ)',
'(size limit %(size)s)': '(%(size)s まで)',
'(ticket not yet created)': '(未登録のチケット)',
'(Undefined)': '(未定義)',
'(unknown template location)': '(テンプレート内の位置が特定できません)',
'[%(section)s] %(entry)s: expected integer, got %(value)s': '[%(section)s] %(entry)s: 整数値でなければなりませんが、 %(value)s が設定されています',
'A positive offset is used to indicate a timezone at the east of Greenwhich, i.e. ahead of Universal Time.': 'プラスのオフセットはグリニッジ天文台の東側の地域のタイムゾーンを示しています。すなわちこれらの地域はグリニッジ標準時より時間が進んでいるのです。',
'About Trac': 'Trac について',
'Action': 'アクション',
'Active': '未解決',
'Add %(field)s': '%(field)sを追加',
'Add a user or group to an existing permission group.': '既設のパーミッショングループにユーザやグループを追加します。',
'Add attachment': '添付ファイルを登録',
'Add Component': 'コンポーネントを追加',
'Add filter': '検索条件の追加',
'Add Milestone': 'マイルストーンを追加',
'Add milestone': '登録',
'Add new milestone': 'マイルストーンの登録',
'Add Subject to Group': 'グループに対象を追加',
'Add to Cc': '関係者に追加',
'Add Version': 'バージョンを追加',
'Add': '追加',
'Add/Change': '追記/更新',
'Add/Remove from Cc': '関係者に追加/削除',
'Added': '追加',
'added': '追加',
'Adjust edit area height': '編集領域の高さを変更',
'Admin': '管理',
'Administration': '管理コンソール',
'Advanced': '高度な設定',
'Age': 'Age', # 翻訳しない
'All upper-cased tokens are reserved for permission names': 'すべて大文字の名前はパーミッション名に予約されています',
'Annotate each line with the last changed revision (this can be time consuming...)': '各行に最後に更新されたリビジョンを表示 (時間がかかります...)',
'Annotate': '注釈履歴形式',
'Apply changes': '変更を適用',
'Are you sure you want to %(completely)s delete %(range)s this page?': 'このページ%(range)sを%(completely)s削除しますか?',
'Are you sure you want to delete this attachment?': '本当に削除してもよろしいですか?',
'Are you sure you want to delete this milestone?': 'このマイルストーンを本当に削除してもいいですか?',
'Are you sure you want to delete this report?': 'このレポートを本当に削除してもいいですか?',
'As long as you don\'t add any items to the list, this field will remain completely hidden from the user interface.': 'リストにアイテムを追加するまで、ユーザインタフェースにこのフィールドは表示されません。',
'Assign to': '担当者',
'at revision': 'リビジョン',
'at version %(rev)s': 'でのバージョン %(rev)s',
'Attach another file': '他のファイルを添付する',
'Attach file': 'ファイルを添付する',
'Attachment \'%(id)s\' in %(parent)s': '%(parent)s への添付ファイル \'%(id)s\'',
'Attachment Info': '添付ファイル情報',
'Attachment Navigation': '添付ファイル ナビゲーション',
'Attachment': '添付ファイル',
'Attachments of %(parent)s': '%(parent)s への添付ファイル',
'Attachments': '添付ファイル',
'Author': '更新者',
'Available Projects': 'プロジェクト一覧',
'Available Reports': 'レポート一覧',
'Back to %(parent)s': '%(parent)s に戻る',
'Back to Query': 'クエリに戻る',
'Back to Ticket #%(id)s': 'チケット #%(id)s に戻る',
'Backup': 'バックアップ',
'Basic Settings': '基本設定',
'Basics': '基本設定',
'begins with': 'が次で始まる',
'Blank lines': '空行',
'Browse at revision %(rev)s': 'リビジョン%(rev)sでブラウズする',
'Browse repository path %(path)s': 'リポジトリ上のパス %(path)s をブラウズする',
'Browse Source': 'リポジトリブラウザ',
'Can\'t synchronize with the repository (%(error)s). Look in the Trac log for more information.': 'リポジトリと同期できません (%(error)s)。詳細は Trac のログを参照してください。',
'Can\'t view %(link)s:': '%(link)s: を表示できません',
'Cancel': '取り消し',
'Cannot load Python bindings for MySQL': 'MySQL の Python バインディングをロード出来ませんでした',
'Cannot load Python bindings for PostgreSQL': 'PostgreSQL の Python バインディングをロード出来ませんでした',
'Cannot load Python bindings for SQLite': 'SQLite の Python バインディングをロード出来ませんでした',
'Case changes': '大文字小文字の変更',
'Cc': '関係者',
'Change History': 'チケットの履歴',
'Change history': '更新履歴',
'Change information for future version %(ver)s (modified by %(aut)s)': '新しいバージョン %(ver)s で更新される情報です (編集者 %(aut)s)', 
'Change information': '更新情報',
'Change Properties': '属性変更',
'Change': '更新',
'changed': '変更',
'ChangeLog': 'ChangeLog', # 訳さない
'Changeset %(id)s for %(path)s': '%(path)s でのチェンジセット %(id)s',
'Changeset %(id)s': 'チェンジセット %(id)s',
'Changeset %(rev)s': 'チェンジセット %(rev)s',
'Changeset': 'チェンジセット',
'Changesets': 'チェンジセット',
'Chgset': 'Chgset', # 翻訳しない
'Closed': '解決済み',
'Columns': '表示項目',
'Comma-delimited Text': 'カンマ区切りテキスト',
'Comment %(cnum)s for Ticket #%(id)s': 'チケット #%(id)s へのコメント %(cnum)s',
'Comment about this change (optional)': 'この更新についてのコメント (非必須)',
'Comment': 'コメント',
'comment': 'コメント',
'Commited': 'がコミットされました。',
'Completed': '完了日時',
'Completed:': '完了にする:',
'completely': '完全に',
'Completion date may not be in the future': '完了日時は未来の日付を許容しません',
'Component %(name)s already exists.': 'コンポーネント %(name)s は既に存在します。',
'Component %(name)s does not exist.': 'コンポーネント %(name)s は存在しません。',
'Component': 'コンポーネント',
'Components': 'コンポーネント',
'Configuration': '設定',
'Configuring your time zone will result in all dates and times displayed on this site to use your time zone instead of that of the server.': 'サーバのタイムゾーンの代わりに、住んでいる地域のタイムゾーンを使用するように設定すると、サイト内の日付と時間を設定したタイムゾーンで表示します。',
'Console': 'コンソール',
'contains': 'に次が含まれる',
'Copied or renamed': 'コピー または 名前変更',
'copied': 'コピー',
'Copy report': 'レポートをコピー',
'Correction': '修正',
'Couldn\'t open Subversion repository %(path)s: %(svn_error)s': 'Subversion リポジトリ %(path)s をオープンできません: %(svn_error)s',
'Create a copy of this ticket': 'このチケットのコピーを作成',
'Create new report from current query': '現在のクエリを新しいレポートとして保存する',
'Create new report': 'レポートの登録',
'Create New Report': '新規レポートの登録',
'Create New Ticket': '新規チケットの登録',
'Create this page': 'このページを作成する',
'Create ticket': 'チケットを登録する',
'Created': '登録',
'Custom Query': 'カスタムクエリ',
'Customization': 'UIのカスタマイズ',
'Date & Time': '日付と時刻',
'Date &amp; Time': '日付と時刻',
'Date': '日付',
'day': '日',
'days': '日',
'Default time zone': 'デフォルトタイムゾーン',
'Default': 'デフォルト',
'Delete %(what)s': '%(what)s を削除',
'delete ': '削除',
'Delete attachment': '添付ファイル削除',
'Delete Milestone %(name)s': 'マイルストーン %(name)s を削除',
'Delete milestone': 'マイルストーンを削除',
'Delete page': 'このページを削除する',
'Delete query': 'クエリを削除',
'Delete report {%(id)s} corresponding to this query': 'このクエリに対応するレポート {%(id)s} を削除する',
'Delete Report {%(num)s} %(title)s': 'レポート {%(num)s} %(title)s を削除します',
'Delete report': 'レポートを削除',
'Delete this version': 'このバージョンを削除する',
'Delete version %(new)d': 'バージョン %(new)d を削除する',
'Delete version %(old)d to version %(new)d': 'バージョン %(old)d から %(new)d を削除する',
'deleted': '削除',
'descending': '降順',
'Describe %(name)s here.': '%(name)s について、ここに記述してください。',
'Description of the file (optional)': 'ファイルについての説明 (非必須)',
'Description': '説明',
'Diff': 'Diff',  # 訳さない
'Diff from %(oldpath)s@%(oldrev)s to %(newpath)s@%(newrev)s': '%(oldpath)s@%(oldrev)s から %(newpath)s@%(newrev)s への diff',
'Diff from Old Revision to New Revision (select them below)': '古いリビジョンと新しいリビジョンの diff を表示する (2 つのリビジョンを選択して下さい)',
'Diff r%(oldrev)s:%(newrev)s for %(newpath)s': '%(newpath)s での r%(oldrev)s:%(newrev)s 間の diff',
'Differences': '差分表示',
'Directory': 'ディレクトリ',
'doesn\'t contain': 'に次は含まれない',
'Download': 'ダウンロード',
'Download in other formats': '異なるフォーマットでダウンロード',
'Due': '完了期限',
'Edit Milestone %(name)s': 'マイルストーン %(name)s を編集',
'Edit milestone': 'マイルストーン情報を編集',
'Edit query': 'クエリを編集',
'Edit Report {%(num)d} %(title)s': 'レポート {%(num)d} %(title)s を編集中です',
'Edit report': 'レポートを編集',
'Edit this page': 'このページを編集する',
'Editing %(name)s': '%(name)s を編集中です',
'Email address': 'メールアドレス',
'Enable access keys': 'キーボード・ショートカットを有効にする',
'Enabled': '有効',
'ends with': 'が次で終わる',
'Error writing to trac.ini, make sure it is writable by the web server. The default value has not been saved.': 'trac.ini への書き込み中にエラーが発生しました。 Web サーバから書き込みできるように設定してください。デフォルト値は保存されませんでした。',
'Error writing to trac.ini, make sure it is writable by the web server. Your changes have not been saved.': 'trac.ini への書き込み中にエラーが発生しました。 Web サーバから書き込みできるように設定してください。変更は保存されませんでした。',
'Error: Can\'t get description for macro %(name)s': 'マクロ %(name)s のドキュメントを取得できません',
'Example': '例',
'field %(name)s must be set': 'フィールド %(name)s は設定する必要があります',
'File Name': 'ファイル名',
'File': 'ファイル',
'Files': 'ファイル',
'Filters': '検索条件',
'Follow copies': 'コピーを追跡する',
'follow-up': 'フォローアップ',
'follow-ups': 'フォローアップ',
'For either path, you can start typing the path and will be presented a list of existing directories and files to select from. Select an entry by clicking on it, or by using the up/down cursor keys and hitting tab.': 'From/To の両方のテキストボックスで、パスを入力すると、リポジトリ上に存在するディレクトリとファイルの一覧が表示されます。一覧上のエントリをクリックするか、上/下のカーソルキーとタブキーを使用することによって一覧上のエントリをテキストボックスに入力させることができます。',
'Format': 'フォーマット',
'Format: %(time)s': 'フォーマット: %(time)s',
'From r%(rev)s': 'r%(rev)s から',
'Full name': 'フルネーム',
'General': '一般設定',
'Genshi %(error)s error while rendering template %(location)s': 'テンプレート %(location)s のレンダリング中に Genshi のエラー %(error)s が発生しました',
'Go to root directory': 'root ディレクトリに移動',
'Go!': '移動',
'Grant permission for an action to a subject, which can be either a user or a group.': 'ユーザまたはグループにアクションを追加するとパーミッションが付与されます。',
'Grant Permission': 'パーミッションの付与',
'Group results by': 'グループ化するチケット属性',
'Group': 'グループ',
'Header length is too short': 'ヘッダの長さが短すぎます',
'Help/Guide': 'ヘルプ/ガイド',
'Hint: clear the field to view latest revision': 'ヒント: フィールドを消すと最新のリビジョンを見ることができます。',
'History': 'ページ履歴',
'Home page': 'ホームページ',
'hour': '時間',
'hours': '時間',
'HTML preview not available.': 'HTML プレビューできません。',
'I have files to attach to this ticket': 'このチケットにファイルを添付します。',
'iCalendar': 'カレンダー',
'id can\'t be set for a new ticket request.': 'チケット登録時は ID を指定できません。',
'Ignore': '無視リスト',
'Index': 'ページ一覧',
'Initial Version': '初期バージョン',
'inline': 'インライン',
'Install Plugin': 'プラグインをインストール',
'Install': 'インストール',
'Installation': 'インストール',
'Insufficient permissions to access %(path)s': '%(path)s へのアクセスが拒否されました',
'Insufficient permissions to access changeset %(id)s': 'チェンジセット %(id)s へのアクセスが拒否されました',
'Insufficient privileges to perform this operation.': 'この操作を行うための充分な権限がありません。',
'Invalid action "%(name)s"': '無効なアクションです "%(name)s"',
'Invalid Changeset Number': '無効なチェンジセット番号',
'Invalid comment threading identifier': 'コメントのスレッド識別子が無効です',
'Invalid Completion Date': '無効な完了日時',
'Invalid email encoding setting: %(str)s': 'メールのエンコーディング設定が無効です: %(str)s',
'Invalid log level': '無効なログレベル',
'Invalid log type': '無効なログ種別',
'Invalid Milestone Name': '無効なマイルストーン名称',
'Invalid Ticket Number': '無効なチケット番号',
'Invalid Wiki page: %(message)s': '無効な Wiki ページです: %(message)s',
'IP': 'IP アドレス',
'IP-Address': 'IP アドレス',
'IP-Address: %(ipnr)s': 'IP アドレス: %(ipnr)s',
'is not': 'は次と等しくない',
'is': 'は次と等しい',
'Jump to the chosen preselected path': '選択したパスに移動する',
'Keyboard Shortcuts': 'キーボード・ショートカット',
'Keywords': 'キーワード',
'Last Change': '最終更新',
'Legend': '凡例',
'less than one hour': '1 時間弱',
'License': 'ライセンス',
'Line numbers': '行番号',
'Line': '行番号',
'Link to this change': 'この履歴への固定リンク',
'Link to this diff': 'この diff へのリンク',
'Link to this section': 'このセクションへのリンク',
'Load': 'ロード',
'Location': 'パス',
'Log file': 'ログファイル',
'Log level': 'ログレベル',
'Log Message': 'ログメッセージ',
'Log type': 'ログの出力先',
'Log': 'Log', # 翻訳しない
'logged in as %(name)s': ' %(name)s としてログイン中',
'Logging': 'ログ',
'Login': 'ログイン',
'Logout': 'ログアウト',
'Manage %(field)s': '%(field)s管理',
'Manage Components': 'コンポーネント管理',
'Manage Milestones': 'マイルストーン管理',
'Manage Permissions': 'パーミッション管理',
'Manage Plugins': 'プラグイン管理',
'Manage Versions': 'バージョン管理',
'Max items per page': 'ページあたりの表示数',
'Merge changes': '変更をマージ',
'Message': 'ログメッセージ',
'Milestone "%(name)s" already exists, please choose another name': 'マイルストーン "%(name)s" は既に存在します。別の名前を入力してください。',
'Milestone %(name)s already exists.': 'マイルストーン %(name)s は既に存在します。',
'Milestone %(name)s deleted': 'マイルストーン %(name)s 自体が削除された。',
'Milestone %(name)s does not exist.': 'マイルストーン %(name)s は存在しません。',
'Milestone %(name)s': 'マイルストーン %(name)s',
'Milestone': 'マイルストーン',
'Milestones': 'マイルストーン',
'minute': '分',
'minutes': '分',
'Missing field': 'フィールドの指定不足',
'modified date': '更新時期',
'Modified': '変更',
'modified': '変更',
'Modify %(field)s': '%(field)s情報を変更',
'Modify Component': 'コンポーネント情報を変更',
'Modify Milestone': 'マイルストーン情報を変更',
'Modify Version': 'マイルストーン情報を変更',
'modify': '更新',
'Modify': '変更',
'month': 'か月',
'months': 'か月',
'moved': '移動',
'Name of the milestone': 'マイルストーン名称',
'Name': '名称',
'Navigation': 'ナビゲーション',
'Need at least PySqlite 1.0.7 or higher': 'PySqlite 1.0.7 以上が必要です',
'Need at least PySqlite 2.0.7 or higher': 'PySqlite 2.0.7 以上が必要です',
'New Milestone': 'マイルストーンを登録',
'New Report': '新規レポートの登録',
'New Ticket': 'チケット登録',
'Next %(label)s': '次の %(label)s',
'Next Page': '次のページ',
'Next period': '次の期間',
'Next status will be \'%(status)s\'': '次のステータスは \'%(status)s\' です',
'Next': '次の',
'No administration panels available': '利用可能な管理パネルが存在しません',
'No changeset %(rev)s in the repository': 'リポジトリにチェンジセット %(rev)s が存在しません',
'No component selected': 'コンポーネントが選択されていません',
'No date set': '完了期限が設定されていません',
'No file uploaded': 'ファイルがアップロードされていません',
'No files found': '該当するファイルが見つかりませんでした',
'No matches found.': '一致するものがありません。',
'No milestone selected': 'マイルストーンが選択されていません',
'No permission to change ticket fields.': 'チケット属性を変更する権限がありません。',
'No permission to edit description.': 'チケットの説明を編集する権限がありません。',
'No permissions to add a comment.': 'コメントを挿入する権限がありません。',
'No results': '0 件のマッチ',
'No revisions found': '該当するリビジョンが見つかりませんでした',
'No such changeset': 'チェンジセットが存在しません',
'No such node': 'ノードが存在しません',
'No svn:externals configured in trac.ini': 'trac.ini に svn:externals が設定されていません',
'No tickets found': '該当するチケットはありませんでした',
'No version "%(num)s" for Wiki page "%(name)s"': 'Wiki ページ "%(name)s" にはバージョン "%(num)s" が存在しません',
'No version selected': 'バージョンが選択されていません',
'no': 'OFF',
'None': 'なし',
'Nonexistent path': '存在しないパス',
'Normal': '通常形式',
'Note': 'Note', # 翻訳しない
'Notice': 'Notice', #翻訳しない
'Notices': 'Notices', #翻訳しない
'Notification': 'メール通知',
'Old / New': '旧 / 新',
'Older Revisions': '古いリビジョン',
'Open (by due date)': '未解決 (完了期限あり)',
'Open (no due date)': '未解決 (完了期限なし)',
'Opened and closed tickets': 'チケットのオープンとクローズ',
'Order': '順序',
'Original Format': '元の形式',
'Owned by': '担当者',
'Owner': '担当者',
'Page': 'ページ',
'page': 'ページ',
'Page %(name)s does not exist': 'Wiki ページ %(name)s は存在しません',
'Page %(name)s not found': 'Wiki ページ %(name)s が見つかりません',
'Page %(num)d': 'ページ %(num)d',
'Page %(page)s is beyond the number of pages in the query': 'ページ %(page)s はこのクエリでのページ数を超えています',
'Page history': 'ページ履歴',
'Page is read-only': 'このページを読み込み専用にする',
'Page not modified': 'ページは変更されていません',
'Page not modified, showing latest version.': 'ページは変更されていません、最新のバージョンを表示します',
'Parent Directory': '親ディレクトリへ移動',
'Parent directory': '親ディレクトリへ移動',
'Path': 'パス',
'Period': '期間',
'Permissions': 'パーミッション',
'Plain Text': 'テキスト',
'Plugin %(name)s already installed': 'プラグイン %(name)s はすでにインストールされています',
'Plugin Author': 'プラグイン作者',
'Plugins': 'プラグイン',
'Preferences': 'ユーザ設定',
'Prefix': 'プレフィックス',
'Prepare Diff': 'Diff の作成',
'Preview Page': 'プレビュー',
'Preview': 'プレビュー',
'Previous %(label)s': '前の %(label)s',
'Previous Page': '前のページ',
'Previous period': '前の期間',
'Previous': '前の',
'previous': '前のリビジョン',
'Priorities': '優先度',
'Priority': '優先度',
'Project': 'プロジェクト',
'Properties': '属性',
'Property': '属性',
'Provide a description list for the known InterWiki prefixes.': '登録済みの InterWiki プレフィックスの一覧を表示します。',
'Provide a list of known InterTrac prefixes.': '登録済みの InterTrac プレフィックスの一覧を表示します。',
'Pygments Theme': 'Pygments テーマ',
'Query filter requires field name': 'クエリの条件には属性名が必要です',
'Query filters': 'クエリの条件',
'Query max %(max)s is invalid.': 'クエリの上限値 %(max)s は無効です',
'Query page %(page)s is invalid.': 'クエリページ %(page)s は無効です',
'Query parameter "sort=%(sort_col)s"  is invalid': 'クエリパラメータ "sort=%(sort_col)s" は無効です',
'Quickjump to %(name)s': '%(name)s にクイックジャンプする',
'Released': 'リリース日時',
'Remove from Cc': '関係者から削除',
'Remove selected items': '選択した項目を削除',
'Removed': '削除',
'removed': '削除',
'Replace existing attachment of the same name': '同名の添付ファイルが存在していた場合、置き換える',
'Reply to comment %(str)s': 'コメント %(str)s に返信', 
'Reply': '返信',
'Reply, quoting this description': 'チケットの説明に返信',
'Replying to [%(field)s %(person)s]': '[%(field)s %(person)s] への返信',
'Report execution failed: %(error)s': 'レポートの実行に失敗しました: %(error)s',
'Report Navigation': 'レポートナビゲーション',
'Report Title': 'レポート名',
'Report': 'レポート',
'Reported by': '報告者',
'Reporter': '報告者',
'Reports': 'レポート',
'Repository Browser': 'リポジトリブラウザ',
'Repository checkins': 'リポジトリへのチェックイン',
'Resolution': '解決方法',
'Resolutions': '解決方法',
'Restore session': 'セッションの復元',
'Results': '検索結果',
'Retarget associated open tickets to milestone': 'このマイルストーンを他のマイルストーンに関連付ける',
'Retarget associated tickets to milestone': 'このマイルストーンを他のマイルストーンに関連付ける',
'Rev': 'Rev', # 翻訳しない
'Reverse Diff': 'Diff を反転',
'Review Changes': '変更を確認',
'Revision in which the line changed': 'この行が変更されたリビジョン',
'Revision info': 'バージョン情報',
'Revision Log (restarting at %(path)s, rev. %(rev)s)': '%(path)s@%(rev)s からのリビジョンログ',
'Revision Log Mode': 'コピー検出時の動作',
'Revision Log': 'リビジョンログ',
'Revision': 'リビジョン', 
'Roadmap': 'ロードマップ',
'RSS Feed': 'RSS フィード',
'RSS Support': 'RSS 対応',
'Save changes': '変更を保存する',
'Save query': 'クエリを保存',
'Save report': '保存',
'Save updated query in report {%(id)s}': '変更されたクエリをレポート {%(id)s} に保存する',
'Save': '保存',
'Schedule': 'スケジュール',
'Search Error': '検索エラー',
'Search query too short. Query must be at least %(num)s characters long.': '検索文字列が短すぎます。最低でも %(num)s 文字必要です。',
'Search Results': '検索結果',
'Search': '検索',
'Select paths and revs for Diff': 'ブランチ間の diff を準備する',
'Select the base and the target for the diff': '見たい diff の Base (From) と Target (To) を指定して下さい',
'Session key': 'セッションキー',
'set': '設定',
'Severities': '重要度',
'Severity': '重要度',
'Show already completed milestones': '既に完了したマイルストーンも表示',
'Show differences': 'diff を表示',
'Show entry in browser': 'エントリを表示',
'Show full changeset': 'チェンジセットを省略せずに表示',
'Show full log messages': 'ログメッセージを省略しない。',
'Show only adds and deletes': '追加、削除だけを表示する',
'Show original file (rev. %(rev)s)': '元のファイルを表示 (rev. %(rev)s)',
'Show previous version in browser': '以前のリビジョンを表示',
'Show revision %(rev)s of this file in browser': 'このファイルのリビジョン %(rev)s を閲覧する',
'Show revision log': 'リビジョンログを見る',
'Show the %(range)s differences restricted to %(path)s': 'このリビジョン間 %(range)s でファイル %(path)s を閲覧する',
'Show the changeset %(id)s restricted to %(path)s': 'このリビジョン %(id)s でファイル %(path)s を閲覧する',
'Show under each result': '検索結果の各行の下に表示する',
'Show what was removed (rev. %(field)s)': 'リビジョン %(field)s で削除されたエントリを表示',
'Shows the milestone completion status grouped by %(group)s': '%(group)s 別に集計したマイルストーンの進捗状況',
'side by side': '並べて表示',
'Since no preview renderer could handle it.': 'レンダリングエンジンが定義されていません。',
'Since the file size exceeds %(max)d bytes.': 'ファイルサイズが %(max)d バイトを超えています。',
'Site': 'サイト',
'Size': 'Size', # 翻訳しない
'skip': '編集領域に移動',
'Sorry, can not save your changes. This ticket has been modified by someone else since you started': '今回の更新は保存できません。このチケットを編集中に、他のユーザがこのチケットを更新しました',
'Sorry, this page has been modified by somebody else since you started editing. Your changes cannot be saved.': 'このページを編集中に、他のユーザがこのページを更新しました。今回の更新は保存できません。',
'Sort by %(title)s%(order)s': '%(title)sでソート%(order)s',
'SQL Query': 'SQL クエリ',
'Start Page': 'スタートページ',
'Status': 'ステータス',
'Stop on copy': 'コピーが発生したら止める',
'Subject': '対象',
'Submit changes': '変更を送信',
'Summary': '概要',
'svn blame failed on %(path)s: %(error)s': '%(path)s への svn blame が失敗しました: %(error)s',
'Syslog': 'syslog',
'Tab-delimited Text': 'タブ区切りテキスト',
'Table of Contents': '目次',
'The %(field)s "%(name)s" has been added.': '%(field)s "%(name)s" が追加されました。',
'The component "%(name)s" has been added.': 'コンポーネント "%(name)s" が追加されました。',
'The file or directory \'%(path)s\' doesn\'t exist at revision %(rev)s or at any previous revision.': 'ファイルまたはディレクトリ \'%(path)s\' はリビジョン %(rev)s 以前のどのリビジョンにも存在しません。',
'The milestone "%(name)s" has been added.': 'マイルストーン "%(name)s" が追加されました。',
'The milestone "%(name)s" has been deleted.': 'マイルストーン "%(name)s" が削除されました。',
'The owner will change from %(current_owner)s': '担当者を %(current_owner)s から変更します',
'The owner will change from %(current_owner)s to %(authname)s': '担当者を %(current_owner)s から %(authname)s に変更します',
'The owner will change from %(current_owner)s to %(selected_owner)s': '担当者を %(current_owner)s から %(selected_owner)s に変更します',
'The page %(name)s has been deleted.': 'Wiki ページ %(name)s は削除されました。',
'The permission %(action)s was already granted to %(subject)s.': 'パーミッション %(action)s は、既に %(subject)s に与えられています。',
'The Pygments syntax highlighter can be used with different coloring themes.': 'Pygments ではソースコードのシンタックスハイライトに使用する色のテーマを変更することができます。',
'The \'repository_dir\' has changed, a \'trac-admin resync\' operation is needed.': '\'repository_dir\' が変更されました。 \'trac-admin resync\' の操作が必要です。',
'The report {%(id)d} has been deleted.': 'レポート {%(id)d} が削除されました。',
'The report has been created.': 'レポートが作成されました。',
'The resolution will be deleted': '解決方法は削除されます',
'The resolution will be set to %s': '解決方法を %s に設定します',
'The resolution will be set': '解決方法を設定します',
'The selected %(fields)s have been removed.': '選択した%(fields)sが削除されました。',
'The selected components have been removed.': '選択したコンポーネントが削除されました。',
'The selected milestones have been removed.': '選択したマイルストーンが削除されました。',
'The selected permissions have been revoked.': '選択したパーミッションが解除されました。',
'The selected versions have been removed.': '選択したバージョンが削除されました。',
'The session key is used to identify stored custom settings and session data on the server. Although it is automatically generated by default, you may change it to something easier to remember at any time if you wish to load your settings in a different web browser.': 'セッションキーはサーバ上に保存した設定とセッションデータを識別するために使用されます。セッションキーは自動生成されますが、他のブラウザでも同じ設定をロードしたい時など、いつでもセッションキーを覚えやすいものに変更することができます。',
'The ticket field \'%(field)s\' is invalid: %(message)s': 'チケットフィールド \'%(field)s\' は無効です: %(message)s',
'The ticket will be disowned': 'このチケットはオーナーなしになります',
'The Trac User and Administration Guide': 'Trac ユーザおよび管理者ガイド',
'The user %(subject)s has been added to the group %(group)s.': 'ユーザ %(subject)s はグループ %(group)s に追加されました。',
'The user %(subject)s has been granted the permission %(action)s.': 'ユーザ %(subject)s にパーミッション %(action)s が付与されました。',
'The user %(subject)s was already added to the group %(group)s.': 'ユーザ %(subject)s は既にグループ %(group)s に参加しています。',
'The version "%(name)s" has been added.': 'バージョン "%(name)s" が追加されました。',
'The version %(version)d of the page %(name)s has been deleted.': 'Wiki ページ %(name)s のバージョン %(version)d は削除されました。',
'The versions %(from_)d to %(to)d of the page %(name)s have been deleted.': 'Wiki ページ %(name)s のバージョン %(from_)d から %(to)d は削除されました。',
'The web server does not have sufficient permissions to store files in the environment plugins directory.': 'プロジェクトのプラグインディレクトリにファイルを保存するのに十分なパーミッションが Web サーバに設定されていません。',
'The Wiki page field \'%(field)s\' is invalid: %(message)s': 'Wiki ページのフィールド \'%(field)s\' が無効です: %(message)s',
'The wiki page is too long (must be less than %(num)s characters)': 'Wiki ページが大きすぎます (%(num)s 文字以内でなければなりません)',
'The Wiki': 'Wiki',
'Theme': 'テーマ',
'This information is used to associate your login name with your email address and full name, which is used for email notification and RSS feeds, for example.': '入力した情報は、ログイン名とメールアドレスやフルネームを関連付けるために使用されます。例えば、メール通知や RSS フィードで使用されます。',
'This information is used to automatically populate some forms on this site with your contact details.': '入力した情報は、このサイト内のフォームであなたの連絡先を自動的に挿入するために使用されます。',
'This is a list of available reports.': '登録されているレポートの一覧です。',
'This is an irreversible operation.': '削除すると元に戻すことができません。',
'This is the only version the page, so the page will be removed completely!': 'このページには1つのバージョンしかありませんのでページを完全に削除します!',
'This page lets you customize your personal settings for this site. These settings are stored on the server and are identified by a session key stored in a browser cookie. That cookie allows your settings to be restored on subsequent visits.': 'このページでは、このサイトにおけるあなたの個人設定をカスタマイズできます。これらの設定はサーバに保存され、ブラウザの cookie に保存されているセッションキーによって識別されます。ブラウザで cookie が有効になっていれば、次にアクセスしたときにも設定が復元されます。',
'this page': 'このページ',
'This site provides keyboard shortcuts for faster access to certain functions of this site. As these shortcuts can cause conflicts with shortcuts provided by the desktop system or web browser, they are disabled by default.': 'このサイトでは、個々の機能に素早くアクセスできるようにキーボードでのショートカットを提供しています。これらのショートカットはデスクトップやブラウザのショートカットの設定とぶつかることがあるので、デフォルトは無効になっています。',
'this version': 'このバージョン',
'those versions': 'これらのバージョン',
'Ticket': 'チケット',
'ticket': 'チケット',
'Ticket #%(id)s': 'チケット #%(id)s',
'Ticket #%(id)s: %(summary)s': 'チケット #%(id)s: %(summary)s',
'Ticket %(id)s does not exist.': 'チケット %(id)s は存在しません。',
'Ticket comment is too long (must be less than %(num)s characters)': 'チケットのコメントが長すぎます (%(num)s 文字以内にして下さい)',
'Ticket contains non-ASCII chars. Please change encoding setting': 'チケットに非 ASCII 文字が含まれています。エンコード設定を変更してください',
'Ticket description is too long (must be less than %(num)s characters)': 'チケットの説明が長すぎます (%(num)s 文字以内にして下さい)', 
'Ticket Diff': 'チケットのdiff',
'Ticket History': 'チケット履歴',
'Ticket Queries': 'チケットクエリ',
'Ticket Query': 'チケットクエリ',
'ticket status': 'チケットのステータス',
'Ticket System': 'チケットシステム',
'Ticket Type': 'チケット分類',
'Ticket Types': 'チケット分類',
'Ticket updates': 'チケットの更新',
'Tickets must contain a summary.': 'チケットは概要を含む必要があります。',
'Tickets': 'チケット',
'Time zone': 'タイムゾーン',
'Timeline': 'タイムライン',
'Timestamp': '更新日時',
'TLS enabled but server does not support TLS': 'TLS が有効に設定されましたが、サーバが TLS をサポートしていません',
'To r%(rev)s': 'r%(rev)s まで',
'Today': '今日',
'Trac Site': 'Trac サイト',
'Type': '分類',
'Unable to get database connection within %(time)d seconds': '%(time)d 秒経過しましたが、データベースへの接続が取得できませんでした',
'Unified Diff': 'Unified Diff', # 訳さない
'Uninstall': 'アンインストール',
'Universal Co-ordinated Time (UTC) is also known as Greenwich Mean Time (GMT).': 'Universal Co-ordinated Time (UTC) は Greenwich Mean Time (GMT) と同意義です。',
'Unknown action': '不明な操作です',
'Unknown administration panel': '不明な管理パネルです',
'Unknown log level %(level)s': '不明なログレベル %(level)s です',
'Unknown log type %(type)s': '不明なログ種別 %(type)s です',
'Unknown preference panel': '不明な設定パネルです',
'Unmodified': '変更なし',
'Unsupported version control system "%(name)s": Can\'t find an appropriate component, maybe the corresponding plugin was not enabled? ': 'サポートされていないバージョン管理システム "%(name)s です: 適切なコンポーネントが見つかりません。該当するプラグインが有効に設定されているか確認してください。',
'Up': '親ページ',
'Update': '更新',
'Upgrading': 'アップグレード',
'Upload a plugin packaged as Python egg.': 'Python egg としてプラグインパッケージをアップロードします。',
'Uploaded file is not a Python source file or egg': 'アップロードされたファイルは Python のソースファイルでも egg ファイルでもありません',
'Using the template': 'テンプレートを使用',
'Version %(name)s already exists.': 'バージョン %(name)s は既に存在します。',
'Version %(name)s does not exist.': 'バージョン %(name)s は存在しません。',
'version %(new)d of ': 'のバージョン %(new)d ',
'Version %(num)s of page %(name)s does not exist': 'Wiki ページ %(name)s にはバージョン %(num)s が存在しません',
'Version %(num)s': 'バージョン %(num)s',
'Version': 'バージョン',
'versions %(old)d to %(new)d of ': 'のバージョン %(old)d から %(new)d ',
'Versions': 'バージョン',
'View %(kind)s': '%(kind)sを表示',
'View %(page)s': '%(page)s を見る',
'View %(part)s': '%(part)s を見る',
'View %(realm)s': '%(realm)sを見る',
'View attachment': 'ファイルを見る',
'View changes': '変更箇所を見る',
'View changeset %(rev)s': 'チェンジセット %(rev)s を見る',
'View changeset [%(rev)s] for %(path)s': '%(path)s でのチェンジセット [%(rev)s] を表示する',
'View differences': 'diff を見る',
'View diffs': 'diff を見る',
'View file without annotations': '注釈履歴をつけずに見る',
'View Latest Revision': '最終のリビジョンを見る',
'View Latest Version': '最新のバージョンを見る',
'View latest version': '最新のバージョンを見る',
'View log starting at this revision': 'このリビジョンまでのリビジョンログを表示する',
'View milestone': 'マイルストーンを見る',
'View parent page': '親ページを見る',
'View removal changeset [%(rev)s]': '削除を行ったチェンジセット [%(rev)s] を表示する',
'View report': 'レポートを見る',
'View Revision Log': 'リビジョンログを見る',
'View revision': 'リビジョンを見る',
'View this version': 'このバージョンを見る',
'View ticket': 'チケットを見る',
'View Tickets': 'チケットを見る',
'Visit': '移動する', 
'Warning': 'Warning',   # 訳さない
'Warnings': 'Warnings', # 訳さない
'week': '週',
'weeks': '週',
'White space changes': '空白文字の変更',
'Wiki changes': 'Wiki ページの更新',
'Wiki Formatting': 'Wiki 文法',
'Wiki History': 'Wiki 履歴',
'Wiki Navigation': 'Wiki ナビゲーション',
'Wiki': 'Wiki',
'Windows event log': 'Windows イベントログ',
'Workflow': 'ワークフロー',
'year': '年',
'years': '年',
'yes': 'ON',
'Yesterday': '昨日',
'You are currently not logged in. You may want to <a href="%(href)s">do so</a> now.': '現在ログインしていません。操作を続けたければ<a href="%(href)s">ログイン</a>してください。',
'You can remove all items from this list to completely hide this field from the user interface.': 'ユーザインタフェースでこのフィールドを使用しない場合は、リストの項目をすべて削除して下さい。',
'You don\'t have permission to replace the attachment %(name)s. You can only replace your own attachments. Replacing other\'s attachments requires ATTACHMENT_DELETE permission.' : '添付ファイル %(name)s を置き換える権限がありません。置き換えられるファイルは自分が添付したファイルだけです。他の人が添付したファイルを置き換えるには ATTACHMENT_DELETE 権限が必要です。',
'You may load a previously created session by entering the corresponding session key below. This lets you share settings between multiple computers and web browsers.': '正しいセッションキーを下のテキストボックスに入力して、以前に作成したセッションをロードします。複数の端末や Web ブラウザで同じ設定を使用することができます。',
'You must specify a log file': 'ログファイル名を指定してください',
'Your changes have been saved.': '変更が保存されました。',
'Your email or username': 'メールアドレスまたはユーザ名',
'Your preferences have been saved.': 'ユーザ設定が保存されました。',
'Your workflow attempts to set a resolution but none is defined (configuration issue, please contact your Trac admin).': 'ワークフローでは解決方法を設定しようとしていますが、解決方法が定義されていません (コンフィグの問題ですので、この Trac の管理者に問い合わせてください)。',
'Zip Archive': 'Zip アーカイブ',
}
