<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/* クッキーファイル読み込み */

// デバッグ用設定
ini_set('log_errors', false);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';

// 設定セット
set_config(read_config());

// クッキー無効
if (!COOKIE || !intval(COOKEI_EXPIRE)) {
    error("クッキー無効のため、読み込みできません");
}

// ユーザの情報
if (REC_UA) {
    $host = gethostbyaddr($_SERVER['REMOTE_ADDR']);
    $ua = getenv("HTTP_USER_AGENT");
}

// アクセスブロック
access_block();

// ファイルの読み込み
if (!$_FILES['cookieFileName'] 
    || ($_FILES['cookieFileName']['type'] != 'text/plain')) {
    error("ファイルが不正です");
}

$data = file($_FILES['cookieFileName']['tmp_name']);

if (!$data[0]) {
    error("内容がありません");
}
if (substr($data[0], 0, 9) != 'name_off=') {
    error("内容が正しくありません");
}

// クッキー出力
$expires = time() + intval(COOKEI_EXPIRE) * 60 * 60 * 24;
$domain = $_SERVER["SERVER_NAME"];

setcookie(COOKIE, $data[0], $expires, $path, '.'.$domain);

// index.phpに戻る
$self_url = get_self_url();
$url = str_replace('cookie_load.php', 'index.php', $self_url);
//print $url;
header('Location: '. $url);
exit;

?>
