<?php
/* 
 * ベンチマークコンポーネント
 * Reffer: http://blog.aidream.jp/cakephp/cakephp-benchmark-component-1366.html
 */

class BenchmarkComponent extends Object {
	var $id = null;
	var $start_time = 0;

	//---------------------------------------------------------------------------
	// コンストラクタ
	//---------------------------------------------------------------------------
	function __construct() {
		$this->id = substr( md5(uniqid(rand(),true)) , 0, 8);
		$this->report('<==construct', true);
	}

	//---------------------------------------------------------------------------
	// デストラクタ
	//---------------------------------------------------------------------------
	function __destruct() {
		$this->report('<==destruct');
	}

	//---------------------------------------------------------------------------
	// 計測してログファイルに出力
	//---------------------------------------------------------------------------
	function report($message = null, $reset = false) {
		if (defined('BENCHMARK_MODE') === false || BENCHMARK_MODE === false) {
			return;
		}
		if ($reset === true) {
			$this->start_time = $this->_getMicroTime();
		}

		$now = $this->_getMicroTime() - $this->start_time;

		$str = sprintf("[%s] %01.5f : %s :", $this->id, $now, $message);
		$this->log($str, LOG_DEBUG);
	}

	//---------------------------------------------------------------------------
	// マイクロタイムを取得
	//---------------------------------------------------------------------------
	function _getMicrotime() {
		if (phpversion() < 5) {
			list($usec, $sec) = explode(" ", microtime());
			return ((float)$usec + (float)$sec);
		} else {
			return microtime(true);
		}
	}
}
