<?php
/**
 * PHP version 5
 *
 * @category App
 * @package  TRPG Data Bank!
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */
class AppError extends ErrorHandler {

	function error($params) {
		$this->controller->layout = "wrap";

		if (!isset($params['message'])) {
			$params['message'] = __('UNKNOWN ERROR', true);
		}

		$this->controller->set(array(
			'message' => $params['message'],
			'base' => $this->controller->base
		));

		$this->_outputMessage('error');
	}

	function errorPcView($params) {
		$this->controller->layout = "mobile_default";

		$this->controller->set(array(
			'name' => __('PC View', true),
			'message' => "For PC browser View",
			'base' => $this->controller->base
		));

		$this->_outputMessage('errorPcView');
	}

}
