<?php
/*
 * Link Plugin for TRPG Databank
 * 
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category ModelTest
 * @package  plugin for TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

App::import('Model', 'Link');
//App::import('Behavoir', 'Tags.Taggable');
/**
 * TestLink
 *
 * @package links
 * @subpackage links.tests.cases.models
 */
class Link extends CakeTestModel {
	public $useTable = 'links';

	public $belongsTo = array();
	public $hasAndBelongsToMany = array();
	public $hasMany = array();
	public $hasOne = array();

	public $actsAs = array();
}

class LinkTestCase extends CakeTestCase {
	public $plugin = 'link';
	public $Link = null;

	var $fixtures = array('plugin.links.link');

	function startTest($method) {
		$this->Link = new Link();

		echo '<h3>The method "' . $method . '" start.</h3>'; 
	}

	function endTest($method) {
		unset($this->Link);

		echo '<h3>The method "' . $method . '" end.</h3>'; 
	}

	public function testAdd() {
		$user_id = 1;

		$this->Link->create();
		$new_data = $this->Link->save(array('Link' => array(
			'user_id' => $user_id,
			'url' => 'http://www.yahoo.co.jp/',
			'title' => 'Title',
			'notes' => 'NoteNoteNote',
		)));
		$this->assertNotEqual($this->Link->id, null);
		$result = $this->Link->find('first', array(
			'conditions' => array(
				'Link.id' => $this->Link->id,
			)
		));

		debug($result);

		$this->assertEqual($result['Link']['user_id'], $new_data['Link']['user_id']);
		$this->assertEqual($result['Link']['url'], $new_data['Link']['url']);
		$this->assertEqual($result['Link']['title'], $new_data['Link']['title']);
		$this->assertEqual($result['Link']['notes'], $new_data['Link']['notes']);
	}

}
