<div class="characterProfileArchives index">
<?php echo $form->create('CharacterProfileArchive', array(
	'url' => array(
		'controller' => 'character_profile_archives',
		'action' => 'multi_edit',
		$character['Character']['id'],
	),
));?>

<h2>
<?php
	echo sprintf(
		__("%s's CharacterProfileArchives", true), 
		$html->link(
			$character['Character']['name'],
			array(
				'controller' => 'characters',
				'action' => 'view',
				$character['Character']['id'],
			), array('escape' => false), false
		)
	);
?>
</h2>
<p>
<?php
	$paginator->options(array('url' => $this->passedArgs));

	echo $paginator->counter(array(
		'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
	));
?></p>

<div class="paging">
<?php echo $paginator->prev('<< '.__('previous', true), array(), null, array('class'=>'disabled'));?>
 | <?php echo $paginator->numbers();?> |
<?php echo $paginator->next(__('next', true).' >>', array(), null, array('class' => 'disabled'));?>
</div>

<table cellpadding="0" cellspacing="0">
<tr>
<th>&nbsp;</th>
<th>
<?php
echo $paginatorEx->sortAllow(__('Date', true),'disp_date');?>
</th>
<th>
<?php 
echo $paginatorEx->sortAllow(__('Title', true),'title');
?>
</th>
</tr>
<?php
	$i = 0;
	foreach ($characterProfileArchives as $characterProfileArchive):
	$class = null;
	if ($i++ % 2 == 0) {
		$class = ' class="altrow"';
	}
?>
<tr<?php echo $class;?>>
<td>
<div class="input checkbox">
<input type="checkbox" name="data[CharacterProfileArchive][id][]" id="CharacterProfileArchiveId_<?php echo $characterProfileArchive['CharacterProfileArchive']['id'] ?>" value="<?php echo $characterProfileArchive['CharacterProfileArchive']['id'] ?>" class="multiSelect">
</div>
</td>
<td>
<?php
	echo $html->link(
		$time->format(
			'Y/m/d H:i',
			$characterProfileArchive['CharacterProfileArchive']['disp_date']
		), 
		array('action' => 'view', $characterProfileArchive['CharacterProfileArchive']['id'])
	); 
?>
</td>
<td>
<?php echo $characterProfileArchive['CharacterProfileArchive']['title']; ?>
<?php if ($isOwner || $isAdmin): ?>
<?php
	echo $html->tag('span', $select->get_i18n_unpublic_flag($characterProfileArchive['CharacterProfileArchive']['public_flag'], $public_flags), array('class' =>  'publicFlag'));
?>
<?php endif; ?>
</td>
</tr>
<?php endforeach; ?>
</table>
</div>

<div class="paging">
<?php echo $paginator->prev('<< '.__('previous', true), array(), null, array('class'=>'disabled'));?>
 | <?php echo $paginator->numbers();?> |
<?php echo $paginator->next(__('next', true).' >>', array(), null, array('class' => 'disabled'));?>
</div>

<div class="characterProfileArchives index form">
<?php
	echo $form->input('mode', array(
		'type' => 'radio',
		'legend' => __('Selected Archives', true),
		'options' => array(
			'public_confirm' => __('Set Public', true),
			'private_confirm' => __('Set Unpublic', true),
			'delete_confirm' => __('Delete All', true),
		),
		'default' => 'public_confirm',
	));

	echo $token->create();
?>
<?php echo $form->end(array('label' => __('Submit', true)));?>
</div>
