<div class="users view">

<div class="user_data">
<?php
	$user_name = $target_user['User']['name'];
	$id = $html->tag('span', 
		'('. sprintf(__('UserNo %d', true), $target_user['User']['id']),
		array(
			'class' => 'text',
		)
	);
	$group = $html->tag('span', 
		$group->get_name4group_id($target_user['User']['group_id']). ')',
		array(
			'class' => 'text',
		)
	);

	$file = $upfile->file(
		'xs', 
		CorePlus::get_value($target_user, 'Attachment.0'),
		array(
			'model_name' => 'User', 
			'mime_type' => 'original',
			'nodata' => 'image',
		)
	);
	$user_img = $upfile->embed(
		$file,
		array(
			'alt' => $target_user['User']['name'],
			'restrict' => array('image'),
			'htmlAttributes' => array(
				'target' => '_blank',
			),
		)
	);

	$edit = $html->tag('span', 
		"[".$html->link(__('Change Password', true), array('action' => 'change_password', $target_user['User']['id']))."]",
		array(
			'class' => 'link',
		)
	);

	$delete = $html->tag('span', 
		"[".$html->link(__('Delete User', true), array('action' => 'delete', $target_user['User']['id']))."]",
		array(
			'class' => 'link',
		)
	);

	$footer = null;
?>
<div class="box">
<div class="boxHeader"><h3><?php echo $user_img. $user_name. $id. $group. $edit. $delete ?></h3></div>
<div class="boxBody">
<dl>
<dt><?php __('Last Login'); ?></dt>
<dd>
	<?php echo $target_user['User']['modified']; ?>
	&nbsp;
</dd>
<dt><?php __('Created'); ?></dt>
<dd>
	<?php echo $target_user['User']['created']; ?>
	&nbsp;
</dd>
<dt><?php __('Id'); ?></dt>
<dd>
	<?php echo $target_user['User']['username']; ?>
</dd>
<dt><?php __('URL'); ?></dt>
<dd>
	<?php echo $html->link($target_user['User']['url'], 
		$target_user['User']['url'],
		array(
			'target' => '_blank',
		)
	); ?>
	&nbsp;
</dd>
<dt><?php __('Pc Mail'); ?></dt>
<dd>
	<?php echo $html->link($target_user['User']['pcmail'], "mailto:".$target_user['User']['pcmail']); ?>
	&nbsp;
</dd>
<dt><?php __('Useragent'); ?></dt>
<dd>
	<?php echo $target_user['User']['useragent']; ?>
	&nbsp;
</dd>
<dt><?php __('Host'); ?></dt>
<dd>
	<?php echo $target_user['User']['host']; ?>
	&nbsp;
</dd>
</dl>
</div>

<div class="boxFooter"><?php if (isset($footer)): ?><?php echo $footer; ?><?php endif; ?></div>
</div>
</div>

<div class="characters">
<?php
	$total =  $html->tag('span', sprintf(__('Total Characters %d', true), count($target_user['Character'])), array('class' => 'total_chara_num'));

	echo $this->element('character_picture_table', array(
		'header' => __('Characters', true). $total,
		'characters' => $target_user['Character'],
		'previewVersion' => 'xs',
		'colNum' => 15,
		'id' => null,
		'isUser' => false,
		'isCharacter' => false,
		'isSystem' => false,
		'isModified' => false,
		'more_url' => array(
			'controller' => 'characters', 
			'action' => 'index',
			$target_user['User']['id'],
		),
	));
?>
</div>


<div class="character_sheets">
<?php
	$body = '<ul class="boxList">';
	foreach($target_user['CharacterSheet'] as $v) {
		$content = $html->link($v['name'], array(
			'controller' => 'character_sheets',
			'action' => 'view',
			$v['id']
		), array('escape' => false), false);
		if (isset($v['System']['name'])) {
			$content .= '('. 
				$html->link($v['System']['name'], array(
					'controller' => 'character_sheets',
					'action' => 'index',
					$v['System']['id']
				), array('escape' => false), false)
				. ')';
		}
		$body .= $html->tag('li', $content,
			array(
			)
		);
	}
	$body .= '</ul>';

	echo $this->element('box', array(
		'id' => 'userCharaShee',
		'header' => __('CharacterSheets', true),
		'body' => $body,
		'footer' => null,
	));
?>
</div>

</div>