<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Controller
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class RegistMailsController extends AppController {

	var $name = 'RegistMails';

	var $components = array(
		'Mail',
		'Crypt',
	);

	var $disableTokenActions = array();

	// listView用のpagenate設定
	var $paginate = array(
		'conditions' => array(
		),
		'fields' => array(
			'RegistMail.id',
			'RegistMail.mail',
			'RegistMail.user_id',
//			'RegistMail.key_code',
			'RegistMail.modified',
			'RegistMail.created',
		),
		'recursive' => -1,
		'limit' => 20,
		'order' => array(
			'RegistMail.modified' => 'asc'
		),
	);

	function beforeFilter() {

		parent::beforeFilter();

		// 認証なしアクセス可
		$this->AuthPlus->allow('add');

		if (!empty($this->user_id)) {
			$this->disableTokenActions = array(
				'add',
				'edit',
			);
		}

	}


	function index() {
			$this->redirect(array('action'=>'add'));
	}

	function add() {
		// メンバー登録にメールアドレス登録必須設定
		if ($this->user_id = null && !$this->site_configs['User.registMail']['value']) {
			$this->redirect(array('controller' => 'users', 'action'=>'add'));
		}

		if (!empty($this->data)) {
			// バリデーション
			$this->RegistMail->set($this->data);
			if ($this->RegistMail->validates()) {

				// 登録済アドレス
				// ユーザ登録済み
				if (!$user_id = $this->RegistMail->isUniquePcMail($this->data['RegistMail'])) {
					$this->Session->setFlash(__('This Address has been registed.', true));
				} else {

					// 仮登録
					if ($id = $this->RegistMail->getRegistId4address($this->data['RegistMail'])) {
						$this->RegistMail->id = $id;
					} else {
						$this->RegistMail->create();
					}

					$to = $this->data['RegistMail']['mail'];
					$this->data['RegistMail']['mail'] = $this->Crypt->crypt($this->data['RegistMail']['mail']);
					$this->data['RegistMail']['key_code'] = $this->setKeyCode();

					// メンバー登録/アドレス登録の処理分け
					if ($this->AuthPlus->user("id")) {
						$this->data['RegistMail']['user_id'] = $this->AuthPlus->user("id");
						$subject = sprintf(__('Address Registration for %s', true), $this->site_configs['Site.siteName']['value']);
					} else {
						$this->data['RegistMail']['user_id'] = null;
						$subject = sprintf(__('Member Registration for %s', true), $this->site_configs['Site.siteName']['value']);
					}

					if ($this->RegistMail->save($this->data, array('validate' => false))) {
						if ($this->AuthPlus->user("id")) {
							$this->Mail->send_mail_regist(
								$this->data['RegistMail']['key_code'], 
								$to, 
								$subject
							);
						} else {
							$this->Mail->send_member_regist(
								$this->data['RegistMail']['key_code'], 
								$to, 
								$subject
							);
						}

						$this->AuthPlus->logout();
						$this->redirect(array('controller' => 'users','action'=>'regist_end'));
					} else {
						$this->data['RegistMail']['mail'] = $to;
						$this->Session->setFlash(__('The Mail Regist could not be done. Please, try again.', true));
					}
				}
			}
		}

		if (isset($this->user['User']['pcmail']) && !empty($this->user['User']['pcmail'])) {
			$this->user['User']['pcmail'] = $this->Crypt->decrypt($this->user['User']['pcmail']);
		}
		$this->set('user', $this->user);

		$this->set('title_for_layout', " - ". __('Regist Mail', true));
	}

	function admin_index() {
		$this->RegistMail->recursive = 0;
		$regist_mails = $this->paginate();

		foreach ($regist_mails as $k => $v) {
			// アドレス復号化
			if (isset($v['RegistMail']['mail']) && !empty($v['RegistMail']['mail'])) {
				$regist_mails[$k]['RegistMail']['mail'] = $this->Crypt->decrypt($v['RegistMail']['mail']);
			}
		}

		$this->set('registMails', $regist_mails);

		$this->set('title_for_layout', " - ". __('RegistMails', true));
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for RegistMail', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->RegistMail->delete($id)) {
			$this->Session->setFlash(__('RegistMail deleted', true));
			$this->redirect(array('action'=>'index'));
		}
	}


	/* keyCode */
	// keyCode発行
	function setKeyCode()
	{
		return Security::generateAuthKey();
	}
}
