<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class News extends AppModel {
	var $name = 'News';

	var $fields = array(
		'add' => array('title', 'value', 'public_flag', 'date', 'end_date'),
		'edit' => array('title', 'value', 'public_flag', 'date', 'end_date'),
		'escape' => array(
			'title' => array(
				'html' => false,
				'tags' => false,
				'images' => false,
				'sctipts' => false,
			),
			'value' => array(
				'html' => false,
				'tags' => false,
				'images' => false,
				'sctipts' => false,
			),
		),
	);

	var $validate = array(
		'title' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
			),
		),
		'value' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
			),
		),
		'date' => array(
			'date' => array(
				'rule' => array('date'),
			),
			'onlyFuture' => array(
				'rule' => array('onlyFuture'),
				'on' => 'create',
			),
		),
		'end_date' => array(
			'date' => array(
				'rule' => array('date'),
			),
		),
	);

	function afterSave($created) {
		$this->deleteCache4News();

		return parent::afterSave($created);
	}
	function afterDelete() {
		$this->deleteCache4News();

		return parent::afterDelete();
	}

	/* キャッシュ削除 */
	function deleteCache4News($news_id = null)
	{
		clearCache('_news.php', 'views', '');
		clearCache('_news_index');
		if ($news_id) {
			clearCache('_news_view_'.$news_id);
		}

		// Home
		if (file_exists(CACHE.'views'.DS.'element_news_cache_information')) {
			@unlink(CACHE.'views'.DS.'element_news_cache_information');
		}
	}

	/* validate */
	function onlyFuture($data, $oneday = true)
	{
		if (empty($data) || (!isset($data['date']) && !isset($data['datetime']))) {
			return false;
		}

		if (isset($data['date'])) {
			$date = $data['date'];
		} else {
			$date = $data['datetime'];
		}

		// 00:00:00時を基準に判定
		$today = date('Y-m-d 00:00:00');
		$today_timestanp = strtotime($today);
		$data_time = strtotime($date);

		if ($data_time >= $today_timestanp) {
			return true;
		} else {
			return false;
		}
	}

}
