<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class ProfileTable extends AppModel {

	var $name = 'ProfileTable';

	var $fields = array(
		'add' => array('profile_id', 'tablekey_name', 'title', 'width', 'sort_order', 'show_list', 'search'),
		'edit_all' => array('tablekey_name', 'title', 'width', 'sort_order', 'show_list', 'search'),
		'escape' => array(
			'title' => array(
				'html' => true,
				'tags' => true,
				'all' => true,
			),
		),
	);

	var $validate = array(
		'title' => array(
			'maxLengthJP' => array(
				'rule' => array('maxLengthJP', 64),
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'tablekey_name' => array(
			'keyNameNg' => array(
				'rule' => 'keyNameNg',
			),
			'keyName' => array(
				'rule' => 'keyName',
			),
			'maxLength' => array(
				'rule' => array('maxLength', 32),
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'width' => array(
			'comparison' => array(
				'rule' => array('comparison', '>=', 0),
				'allowEmpty' => true,
			),
			'numeric' => array(
				'rule' => 'numeric',
				'allowEmpty' => true,
			),
		),
		'sort_order' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'allowEmpty' => true,
			),
		),
		'show_list' => array(
			'boolean' => array(
				'rule' => 'boolean',
				'allowEmpty' => true,
			),
		),
		'search' => array(
			'boolean' => array(
				'rule' => 'boolean',
				'allowEmpty' => true,
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $belongsTo = array(
		'Profile' => array(
			'className' => 'Profile',
			'foreignKey' => 'profile_id',
			'conditions' => '',
			'fields' => '',
		)
	);

	var $hasMany = array(
		'ProfileTableStatic' => array(
			'className' => 'ProfileTableStatic',
			'foreignKey' => 'profile_table_id',
			'associationForeignKey' => 'id',
			'dependent' => true,
			'conditions' => '',
			'fields' => '',
//			'order' => array('ProfileTableStatic.sort_order' => 'asc'),
			'limit' => '',
			'offset' => '',
			'finderQuery' => '',
			'deleteQuery' => '',
			'insertQuery' => ''
		),
		'CharactersHasProfile' => array(
			'className' => 'CharactersHasProfile',
			'foreignKey' => 'profile_table_id',
			'associationForeignKey' => 'id',
			'dependent' => true,
			'conditions' => '',
			'fields' => '',
			'order' => array('CharactersHasProfile.id' => 'asc'),
			'limit' => 10,
			'offset' => '',
			'finderQuery' => '',
			'deleteQuery' => '',
			'insertQuery' => ''
		),
		'DefaultProfile' => array(
			'className' => 'DefaultProfile',
			'foreignKey' => 'profile_table_id',
			'dependent' => true,
			'conditions' => '',
			'fields' => '',
			'order' => array('DefaultProfile.id' => 'asc'),
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

	/* validation Rule */

	/* 同じProfileに同tablekey_nameは不可 */
	function isUniqueKeyname4profile($data, $profile_id, $id = null) 
	{
		$params = array(
			'conditions' => array(
				'ProfileTable.profile_id' => $profile_id,
				'ProfileTable.tablekey_name' => $data['tablekey_name'],
			),
			'recursive' => -1,
		);

		if($id) {
			$params['conditions']['ProfileTable.id !='] = $id;
		}

		return !($this->find('count', $params));
	}


	/* コールバックメソッド */
	function beforeSave($options = array())
	{
		if (empty($this->data['ProfileTable']['sort_order'])) {
			$this->data['ProfileTable']['sort_order'] = 0;
		}

		return parent::beforeSave($options);
	}

	function afterSave($created) {
		$this->deleteCache4ProfileChilds();

		return parent::afterSave($created);
	}
	function afterDelete() {
		$this->deleteCache4ProfileChilds();

		return parent::afterDelete();
	}

}
