<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class System extends AppModel {

	var $name = 'System';

	var $fields = array(
		'add' => array('name', 'sort_order', 'url', 'copyright', 'set_npc', 'public_flag', 'detail', 'ad'),
		'edit' => array('name', 'sort_order', 'url', 'copyright', 'set_npc', 'public_flag', 'detail', 'ad'),
		'edit_all' => array('sort_order'),
		'image' => array(
			'user_id',
			'model',
			'foreign_key',
			'dirname',
			'basename',
			'checksum',
			'size',
			'group',
			'alternative',
			'file',
		),
		'escape' => array(
			'name' => array(
				'html' => true,
				'tags' => true,
				'all' => true,
			),
			'copyright' => array(
				'html' => true,
				'tags' => false,
				'images' => true,
				'sctipts' => true,
			),
			'detail' => array(
				'html' => true,
				'tags' => true,
				'images' => true,
				'sctipts' => true,
			),
			'ad' => array(
				'html' => false,
				'tags' => false,
				'images' => false,
				'sctipts' => false,
			),
		),
	);

	var $validate = array(
		'name' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
			),
		),
		'sort_order' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'allowEmpty' => true,
			),
		),
		'url' => array(
			'url' => array(
				'rule' => array('url', true),
				'allowEmpty' => true,
			),
		),
		'set_npc' => array(
			'boolean' => array(
				'rule' => array('boolean'),
				'allowEmpty' => true,
			),
		),
		'public_flag' => array(
			'publicFlag' => array(
				'rule' => array('publicFlag'),
				'allowEmpty' => true,
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	var $hasMany = array(
		'Character' => array(
			'className' => 'Character',
			'foreignKey' => 'system_id',
			'dependent' => false,
			'conditions' => array(
				'Character.public_flag' => 1,
				'Character.deleted' => '0',
			),
			'fields' => array(
				'Character.id',
				'Character.system_id',
				'Character.user_id',
				'Character.name',
				'Character.main_picture',
				'Character.public_flag',
				'Character.status',
				'Character.modified',
			),
			'order' => 'Character.modified DESC',
			'limit' => '5',
		),
		'CharacterSheet' => array(
			'className' => 'CharacterSheet',
			'foreignKey' => 'system_id',
			'dependent' => false,
			'conditions' => array(
				'CharacterSheet.public_flag' => 1
			),
			'fields' => array(
				'CharacterSheet.id',
				'CharacterSheet.key_name',
				'CharacterSheet.name',
			),
			'order' => array(
				'CharacterSheet.sort_order' => 'ASC'
			),
			'limit' => '',
		),
		'Profile' => array(
			'className' => 'Profile',
			'foreignKey' => 'system_id',
			'dependent' => true,
			'fields' => array(
				'Profile.id',
				'Profile.name',
				'Profile.key_name',
				'Profile.profile_type',
				'Profile.all_public',
				'Profile.required',
				'Profile.show_list',
				'Profile.sort_order',
			),
//			'order' => 'Profile.sort_order ASC',
		),
		// システムイメージ
		'Attachment' => array(
			'className' => 'Media.AttachmentEx',
			'foreignKey' => 'foreign_key',
			'dependent' => true,
			'conditions' => array('Attachment.model' => 'System'),
			'fields' => array(
				'Attachment.id',
				'Attachment.user_id',
				'Attachment.foreign_key',
				'Attachment.dirname',
				'Attachment.basename',
				'Attachment.alternative',
				'Attachment.size',
				'Attachment.created',
			),
			'dependent' => true,
			'order' => '',
			'limit' => '',
			'offset' => '',
			'finderQuery' => '',
			'deleteQuery' => '',
			'insertQuery' => ''
		)
	);

	/* コールバックメソッド */
	function beforeSave($options = array())
	{
		if (empty($this->data['System']['sort_order'])) {
			$this->data['System']['sort_order'] = 0;
		}

		return parent::beforeSave($options);
	}

	function beforeDelete($cascade = true) {
		$this->data['System']['isAdmin'] = true;

		return parent::beforeDelete($cascade);
	}
}

