<?php 
/*
 * Link Plugin for TRPG Databank
 * 
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Element
 * @package  plugin for TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

if (!isset($length)) {
	$length = 76;
}

?>
<div class="SimpleBox" id="Link_index">
<div class="innerBox smallInnerBox">
<div class="box full">

<div class="boxHeader">
<?php
$url = array(
	'controller' => 'links',
	'action' => 'visit',
	'plugin' => 'links',
	'admin' => false,
	$link['Link']['id']
);


if (!empty($link['Link']['title'])) {
	$title = $this->Text->truncate($link['Link']['title'], $length, array(
		'html' => true,
	));
} else {
	$title = __('No Title', true);
}

if (!empty($link['Attachment'])) {
	echo $this->element('link_banner', array(
		'attachment' => $link['Attachment'][0],
		'name' => $title,
		'options' => array(
			'url' => $url,
			'htmlAttributes' => array(
				'title' => $title,
			),
		)
	));
}
?>
<h3>
<?php
	echo $this->Html->link(
		$title,
		$url, 
		array(
			'escape' => false,
			'target' => '_blank',
		),  false
	);

if ($link['Link']['pickup']) {
	echo $this->Html->tag('span', 
		__('PickUp', true),
		array(
			'class' => 'linkMark pickUp',
		)
	);
}

if ($showType && $link['Link']['type']) {
	echo $this->Html->tag('span', 
		'['. $linkSelect->get_i18n_type($link['Link']['type'], $type). ']',
		array(
			'class' => 'linkMark LinkType',
		)
	);
}

	//echo $link['Link']['not_found'];
?>
<div class="linkUrl"><?php echo $link['Link']['url']; ?></div>
</h3></div>
<div class="boxBody">
<div class="infoBody">
<script language="JavaScript">
<!--
	var thumbnailweb_jump = '<?php echo $this->Html->url($url) ?>';
//-->
</script>
<?php
$ThumnailNotice = null;
if ($this->Time->wasWithinLast('2 hours', $link['Link']['created'])) {
	$ThumnailNotice = $this->Html->div('ThumnailNotice',
		__('It takes 1-2 hours for creating thumnail', true)
	);
}

echo $this->Html->div('linkThumnail', 
	$this->Html->script(
		$thumbnail['api_url']
		.'?'.$thumbnail['size']['s']
		.'&'.$thumbnail['user_key']
		.'&'.$link['Link']['url']
	). $ThumnailNotice
	
);
echo $this->Html->div('linkDetail', $link['Link']['notes']);
?>
</div>

<div class="infoModified">
<?php echo __('Author', true) ?>:<span><?php echo $this->Html->link($link['User']['name'], array('controller' => 'users', 'action' => 'view', $link['User']['id'])); ?></span>

(<?php __('Modified') ?>:<span><?php echo $time->niceshort($link['Link']['modified']); ?></span>)

<?php echo __('Id', true); ?>:<span><?php echo $link['Link']['id']; ?></span>

<?php if (!$isDelete): ?>
<?php if ($isAdmin || ($link['Link']['user_id'] == $user['User']['id'])): ?>

<?php
echo $this->Html->tag('span', 
	$this->Html->link(
		__('Edit', true),
		array(
			'action' => 'edit',
			$link['Link']['id']
		)
	),
	array(
		'class' => 'linkEdit',
	)
);
echo $this->Html->tag('span', 
	$this->Html->link(
		__('Delete', true),
		array(
			'action' => 'delete',
			$link['Link']['id']
		), null
	),
	array(
		'class' => 'linkEdit',
	)
);
?>
</span>
<?php endif; ?>
<?php endif; ?>
</div>

</div>
</div>
</div>
</div>

<?php if ($isDelete): ?>
<?php 
	echo $this->Form->create('Link', array(
		'url' => array(
			'plugin' => 'links',
			'controller' => 'links',
			'action' => 'delete',
			$link['Link']['id'],
		),
	));
	echo $this->Form->input('confirm', array(
		'type' => 'hidden',
		'value' => 1
	));
	echo $token->create();
	echo $this->Form->end(__('Delete', true));
?>

<div class="backButton">
<?php
	echo $form->create('', array('url' => array(
			'plugin' => 'links',
			'controller' => 'links',
			'action' => 'listview',
		), 
		'type' => 'GET', 
		'id' => 'CancelButton'
	));
	echo $form->end(array('label' => __('Cancel', true)));
?>
</div>
<?php endif; ?>
