<?php 
/**
 * mediaプラグインアップロードファイル出力用ヘルパー
 * Mediaヘルパー拡張
 */

App::import('Vendor', 'Media.Media');

class UpfileHelper extends MediaHelper {
	var $helpers = array('Html', 'Media');

/**
 * Huck of Media::file()
 * Resolves partial path
 * Generates Version File if it dose not exist.
 * Touches the Version File if it exists.
 * $size: s, m, l...
 * $arg[1]: Data of type Attachment.0
 * $arg[2]: options
 */
	function file($previewVersion)
	{
		if (!isset($previewVersion)) {
			return null;
		}
		$args = func_get_args();

		// ファイル指定がない場合
		if (empty($args[1])) {
			if (isset($args[2]['nodata']) && !empty($args[2]['nodata'])) {
				$data = array(
					'id' => 0,
					'model' => NULL,
					'foreign_key' => NULL,
					'dirname' => '',
					'basename' => '',
					'checksum' => '',
					'group' => '',
					'alternative' => '',
				);

				if ($args[2]['nodata'] == 'image') {
					$data['dirname'] = 'img';
					$data['basename'] = 'noimage.png';
					$data['alternative'] = 'No Image';
				} else {
					return NULL;
				}
			} else {
				return NULL;
			}
		} else {
			$data = $args[1];
		}

		$path = $previewVersion. DS. $data['dirname']. DS. $data['basename']; 

		// ファイルがある場合、ファイルパスを返す
		$file = parent::file($path);
		if (is_file($file) && is_readable($file)) {
			return $file;
		// ファイルがない場合、作成
		} else {
			require_once(APP.'plugins'.DS.'media'.DS.'libs'.DS.'upfile.php');
//			$make_result = Upfile::make_version($path, $data, $args[2]);
			$maked_version = Upfile::make_version($previewVersion, $path, $args[2]);

			// cacheを削除して$file読み込み
			if (!empty($maked_version)) {
				parent::__destruct();
				return self::file($previewVersion, $args[1], $args[2]);
			}
		}

		return null;
	}


/**
 * Extend method of Media::embed()
 * Generates markup to render a file inline
 * Link to $options['linkTo'].
 * HtmlAttributes can be userd for the link as $options['htmlAttributes'].
 */
	function embed($path, $options = array()) {
		if (!isset($path)) {
			return null;
		}

		if (isset($options['linkTo']) && !empty($options['linkTo'])) {
			unset($options['url']);
		}

		$out = $this->Media->embed($path, $options);

		if (!isset($options['linkTo']) || empty($options['linkTo'])) {
			return $out;
		}

		if (!isset($options['htmlAttributes'])) {
			$options['htmlAttributes'] = array();
		}
		$options['htmlAttributes'] = array_merge(array('escape' => false), $options['htmlAttributes']);
		return $this->Html->link($out, $options['linkTo'], $options['htmlAttributes'], false);
	}


	// orig Versionファイルにリンクする
	function embed_linkto_orig($file, $item, $model, $options = array()) {
		$orig_size_filepath = self::file(
			'filter/orig', 
			$item, 
			array(
				'model_name' => $model, 
				'mime_type' => 'original',
			)
		);
		$options['linkTo'] = parent::url($orig_size_filepath, true);

		return self::embed($file, $options);
	}

/**
 * Generates file information
 */
	function fileInfo($file, $item)
	{
		if (empty($file)) {
			return null;
		}
		$Media = Media::factory($file);
		$size = $item['size'];

		if (isset($number)) {
			$size = $number->toReadableSize($size);
		} else {
			$size .= ' Bytes';
		}

		return sprintf('<div class="fileOptions"><em>%s</em>&nbsp;(%s/%s)</div>',
			$item['alternative'],
//			$url ? $html->link($item['basename'], $url) : $item['basename'],
			strtolower($Media->name), 
			$size
		);

	}

	/* $attachments情報からファイルパスを取得 */
	function get_charaimage_version_path4attachment($attachment, $options = array())
	{
		return self::file(
			$options['previewVersion'], 
			$attachment,
			$options
		);
	}

	/* basenameからファイルパスを取得 */
	function get_cet_charaimage_version4basename($basename, $options = array())
	{
		$data = array();
		if (!empty($basename)) {
			$alternative = null;
			if (isset($options['alternative'])) {
				$alternative = $options['alternative'];
				unset($options['alternative']);
			}
			$data = array(
				'dirname' => 'img',
				'basename' => $basename,
				'alternative' => $alternative,
			);
		}
		return self::get_charaimage_version_path4attachment($data, $options);
	}

	function setting_charaimage_version_path($options = array())
	{
		$default_options = array(
			'previewVersion' => 'l',
			'class' => '',
			'url' => '',
			'alternative' => '',
			'model_name' => 'CharacterPicture',
			'mime_type' => 'original',
			'nodata' => 'image',
			'htmlAttributes' => array(),
		);

		return array_merge($default_options, $options);
	}
}
