<?php
if (empty($site_configs['Site.myHome']['value']) && !empty($isOwner)) {
	echo $this->element('information', array(
		'cache' => time() + Configure::read('Cache.expireLong'),
	));
}
?>

<div class="characters listview">
<div class="box full">
<div class="boxHeader"><h2><span>
<?php if (isset($this_system) && !$site_configs['System.singleSystem']['value']): ?>
	<?php echo $html->link($this_system['System']['name'], array('controller' => 'systems', 'action' => 'view', $this_system['System']['id']), array('escape' => false), false) ?>
<?php endif; ?>
<?php if (!empty($userSet)): ?>
 <?php
	printf(__("%s's", true), 
		$html->link($userSet['User']['name'], 
			array('controller' => 'users', 'action' => 'view', $userSet['User']['id']), 
			array('escape' => false), false
		)
	);
?>
<?php endif; ?>
<?php if ($selected_status != 'all' && $selected_status != 1): ?>
<?php echo $select->get_i18n_status($selected_status, $status2);?>
<?php endif; ?>
<?php __('Character List');?>
</span>
<span class="selectStatus">[
<?php 
foreach ($status2 as $k => $v) {
	if ($k != 'active') {
		echo " | ";
	}
	$url = array_merge($this->params['named'], array('status' => $v));
	if ($v != $selected_status) {
		$txt = $html->link(
			$select->get_i18n_status($v, $status2), 
			$url, 
			array('escape' => false), 
			false
		);
	} else {
		$txt = $select->get_i18n_status($v, $status2);
	}

	echo $html->tag('span', 
		$txt,
		array()
	);
}
?>
]</span>
<?php if (!isset($isSearch)): ?>
<span>
<?php 
$url = array('action' => 'search');
if ($isAdmin) {
	$url['prefix'] = Configure::read('Routing.prefixes');
} else {
	if ($isOwner) {
		$url['action'] = 'mysearch';
	}
	$url['prefix'] = null;
}
if (isset($userSet['User']['id'])) {
	$url[] = $userSet['User']['id'];
}
if (isset($this->passedArgs['status'])) {
	$url['status'] = $this->passedArgs['status'];
}
if (isset($this->passedArgs['system'])) {
	$url['system'] = $this->passedArgs['system'];
}

echo $html->image('../img/SA/search_l_b.gif');
echo $html->link(__('Search', true), $url);
?>
</span>
<?php endif; ?>
</h2></div>
<div class="boxBody">
<p>
<?php
$pagenator_options = array();

$paginator->options(array('url' => $this->passedArgs));

echo $paginator->counter(array(
'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
));
?></p>
<div class="paging">
<?php echo $paginator->prev('<< '.__('previous', true), array(), null, array('class'=>'disabled'));?>
 | <?php echo $paginator->numbers();?> | 
<?php echo $paginator->next(__('next', true).' >>', array(), null, array('class' => 'disabled'));?>
</div>
<table>
<tr>
	<th><?php echo $paginatorEx->sortAllow(__('Id', true), 'id', $pagenator_options);?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Charater Name', true), 'name', $pagenator_options);?></th>
<?php if ($site_configs['Character.listImage']['value'] == 2 || $site_configs['Character.listImage']['value'] == 1): ?>
	<th><span class="NoSortTh"><?php __('Picture');?></span></th>
<?php endif; ?>
<?php if (!isset($this_system) && !$site_configs['System.singleSystem']['value']): ?>
	<th><?php echo $paginatorEx->sortAllow(__('System', true), 'system_id', $pagenator_options);?></th>
<?php endif; ?>
<?php if (empty($userSet)): ?>
	<th class="Character_usernameTh"><?php echo $paginatorEx->sortAllow(__('User Name', true), 'user_id', $pagenator_options);?></th>
<?php endif; ?>
	<th class="Character_modifiedTh"><?php echo $paginatorEx->sortAllow(__('Modified', true), 'modified', $pagenator_options);?></th>
<?php if ($selected_status == 'all'): ?>
	<th><?php echo $paginatorEx->sortAllow(__('Status', true), 'status', $pagenator_options);?></th>
<?php endif; ?>
<?php if (isset($this_system['Profile'])): ?>
<?php foreach ($this_system['Profile'] as $k => $profile): ?>
<?php if ($profile['key_name'] != 'table' && $profile['key_name'] != 's-table'): ?>
	<th id="Profile_<?php echo $profile['key_name']; ?>th"><?php echo $profile['name'];?></th>
<?php endif; ?>
<?php endforeach; ?>
<?php endif; ?>
</tr>
<?php
$i = 0;
foreach ($characters as $character):
	$class = null;
	if ($i++ % 2 == 0) {
		$class = ' class="altrow"';
	}
?>
<tr<?php echo $class;?>>
<td>
	<?php echo $character['Character']['id']; ?>
</td>
<td>
	<?php echo $html->link($text->truncate($character['Character']['name'], 32), array('action' => 'view', $character['Character']['id']), array('escape' => false), false); ?>
<?php if ($isAdmin || ($isOwner && $character['Character']['public_flag'] != 1)): ?>
<span class="publicFlag"><?php echo $select->get_i18n_unpublic_flag($character['Character']['public_flag'], $public_flags) ?></span>
<?php endif; ?>
</td>
<?php if ($site_configs['Character.listImage']['value'] == 2 || $site_configs['Character.listImage']['value'] == 1): ?>
<td class="center">
<?php if ($site_configs['Character.listImage']['value'] == 2): ?>
<?php
	$picture = $this->element('character_picture_image', array(
		'basename' => $character['Character']['main_picture'],
		'options' => array(
			'previewVersion' => 'xs',
			'class' => '',
			'url' => array('controller' => 'characters', 'action' => 'view', $character['Character']['id']),
			'alternative' => '',
			'nodata' => '',
		)
	));

	echo $html->div('attachments', $picture);
?>
<?php elseif ($site_configs['Character.listImage']['value'] == 1 && !empty($character['Character']['main_picture'])): ?>
<?php echo $html->link($site_configs['Character.listImageString']['value'], array('controller' => 'character', 'action' => 'view', $character['Character']['id']), array('escape' => false), false); ?>
<?php endif; ?>
</td>
<?php endif; ?>
<?php 
	$character_list_url = array(
		'controller' => 'characters', 
		'action' => 'index'
	);

	if (!empty($userSet)) {
		$character_list_url[] = $userSet['User']['id'];
	}

	if (!empty($selected_status)) {
		$character_list_url['status'] = $selected_status;
	}

 ?>
<?php if (!isset($this_system) && !$site_configs['System.singleSystem']['value']): ?>
<td>
<?php 
	echo $html->link($character['System']['name'], array_merge($character_list_url, array('system:'.$character['System']['id'])), array('escape' => false), false);
?>
</td>
<?php endif; ?>
<?php if (empty($userSet)): ?>
<td>
<?php 
	$character_list_url[] = $character['User']['id'];
	if (isset($this_system)) {
		$character_list_url[] = 'system:'.$this_system['System']['id'];
	}
	echo $html->link($text->truncate($character['User']['name'], 16), $character_list_url, array('escape' => false), false); 
?>
</td>
<?php endif; ?>
<td>
	<?php echo $time->niceShort($character['Character']['modified'], array('format' => 'Y/m/d H:i')); ?>
</td>
<?php if ($selected_status == 'all'): ?>
<td>
	<?php echo $select->get_i18n_status($character['Character']['status'], $status); ?>
</td>
<?php endif; ?>

<?php if (isset($this_system['Profile'])): ?>
<?php foreach ($this_system['Profile'] as $k => $profile): ?>
<td id="Profile_<?php echo $profile['key_name']; ?>_<?php echo $character['Character']['id'] ?>_td">
<?php
if (isset($profile['id']) && !empty($profile['id'])) {
	$items = array();
	foreach ($character['CharactersHasProfile'] as $k => $characterProfiles) {
		if ($characterProfiles['profile_id'] == $profile['id']) {
			$items['CharactersHasProfile'][] = $characterProfiles;
		}
	}
	if (!empty($items)) {
		$public = true;
		if ($isAdministrator || $isOwner) {
			$public = false;
		}
		$profiledisp->set_profile_type4view($profile);
		$profiledisp->disp_values4characters_has_profiles($items, 0, false, $character['Character']['id'], $public);
	}
} else {
	echo "&nbsp;";
}
?>
</td>
<?php endforeach; ?>
<?php endif; ?>

</tr>
<?php endforeach; ?>
</table>

<div class="paging">
<?php echo $paginator->prev('<< '.__('previous', true), array(), null, array('class'=>'disabled'));?>
 | <?php echo $paginator->numbers();?> | 
<?php echo $paginator->next(__('next', true).' >>', array(), null, array('class' => 'disabled'));?>
</div>

</div>
</div>

</div>