<?php
/* 
 * キャラクターシート表示用Helper
 */
class CharacterSheetHelper extends Helper {
	var $helpers = array(
		'Html',
		'Form',
		'Time',
//		'Profiledisp',
	);

	var $isOwner = null;

	function __construct()
	{
		parent::__construct();

		$this->isOwner = Configure::read('isOwner');
	}

	/* 単純表示 */
	function profileName4key_name($profile, $key_name)
	{
		$this->output4key_name($profile, $key_name, '', 'name');
	}
	function profileValue4key_name($profile, $key_name)
	{
		$this->output4key_name($profile, $key_name);
	}
	function output4key_name($profile, $key_name, $model = 'CharactersHasProfile', $target = 'value', $key = 0)
	{
		if (empty($profile) || empty($key_name)) {
			echo null;
		} else {
			if (isset($profile[$key_name][$model][$key][$target])) {
				if ($this->isOwner || CorePlus::check_public_flag2($profile[$key_name]['CharactersHasProfile'][$key])) {

					$class = null;
					if ($this->isOwner && !CorePlus::check_public_flag2($profile[$key_name]['CharactersHasProfile'][$key])) {
						$class = 'publicFlagBg';
					}
					echo $this->Html->tag('span', 
						$profile[$key_name]['CharactersHasProfile'][$key][$target], 
						array(
							'class' => $class,
						)
					);
				} else {
					echo "&nbsp;";
				}
			} elseif (empty($model) && isset($profile[$key_name][$target])) {
				echo $profile[$key_name][$target];
			} else {
				echo "&nbsp;";
			}
		}
	}

	/* 繰り返し表示 */
	/* m-input表示 */
	// key_nameを指定して全データ表示
	function multiInput4key_name($profile, $key_name, $pattern)
	{
		if (empty($profile) || empty($key_name) || empty($pattern)) {
			return;
		}

		if (!isset($profile[$key_name]['CharactersHasProfile'])) {
			return;
		}

		foreach($profile[$key_name]['CharactersHasProfile'] as $hasProfile) {
			if ($this->isOwner || CorePlus::check_public_flag2($hasProfile)) {
				$class = null;
				if ($this->isOwner && !CorePlus::check_public_flag2($hasProfile)) {
					$class = 'publicFlagBg';
				}
				$this->formatValues($pattern, 
					$this->Html->tag('span', 
						$hasProfile['value'], 
						array(
							'class' => $class,
						)
					)
				);
			}
		}
	}

	/* Table表示 */
	// key_nameとtable_keynameを指定して全データ表示
	function table4tablekey_name($profile, $key_name, $tablekey_names, $pattern)
	{
		if (empty($profile) || empty($key_name) || empty($tablekey_names) || empty($pattern)) {
			echo null;
		}

		if (!isset($profile[$key_name]['ProfileTable'])) {
			echo null;
		}

		// $tablekey_namesに対応するデータ抽出
		$CharactersHasProfiles = array();
		foreach($tablekey_names as $k => $v) {
			$table = Set::extract('/'.$key_name.'/ProfileTable[tablekey_name='.$v.']', $profile);

			unset($table[0]['ProfileTable']['ProfileTableStatic']);
			if (isset($table[0]['ProfileTable'])) {
				$hasProfile = Set::extract('/'.$key_name.'/CharactersHasProfile[profile_table_id='.$table[0]['ProfileTable']['id'].']', $profile);
				if (!empty($hasProfile)) {
					foreach($hasProfile as $v2) {
						$CharactersHasProfiles[$table[0]['ProfileTable']['id']][] = $v2['CharactersHasProfile'];
					}
				}
			}
		}

		// $patternにあてはめて出力
		$row_num = count(reset($CharactersHasProfiles));
		for ($i=0;$i<$row_num;$i++) {
			$data = array();
			while(list($profile_table_id, $hasProfile) = each($CharactersHasProfiles)) {
				if ($this->isOwner || CorePlus::check_public_flag2($hasProfile[$i])) {
					$class = null;
					if ($this->isOwner && !CorePlus::check_public_flag2($hasProfile[$i])) {
						$class = 'publicFlagBg';
					}
					$data[] = $this->Html->tag('span', 
						$hasProfile[$i]['value'], 
						array(
							'class' => $class,
						)
					);
				}
			}

			if (!empty($data)) {
				$this->formatValues($pattern, $data);
			}
			reset($CharactersHasProfiles);
		}
	}

	/* 固定テーブルの項目を指定して表示 */
	// $key_name の $tablekey_name $row行目  指定
	function staticTable4row_tablekey_name($profile, $key_name, $tablekey_name, $row)
	{
		$row = intval($row);
		if (empty($profile) || empty($key_name) || empty($pattern) || empty($tablekey_name) || empty($row)) {
			echo null;
		}

		if (!isset($profile['ProfileTable']) || !isset($profile['ProfileTable'])) {
			echo null;
		}

		// $tablekey_name, $rowに対応するデータ抽出と出力
		$table = Set::extract('/'.$key_name.'/ProfileTable[tablekey_name='.$tablekey_name.']', $profile);
		unset($table[0]['ProfileTable']['ProfileTableStatic']);
		if (isset($table[0]['ProfileTable'])) {
			$hasProfile = Set::extract('/'.$key_name.'/CharactersHasProfile[profile_table_id='.$table[0]['ProfileTable']['id'].']', $profile);

			if (!empty($hasProfile)) {
				$key = $row - 1;
				if (isset($hasProfile[$key]['CharactersHasProfile']['value'])) {
					if ($this->isOwner || CorePlus::check_public_flag2($hasProfile[$key]['CharactersHasProfile'])) {

						$class = null;
						if ($this->isOwner && !CorePlus::check_public_flag2($hasProfile[$key]['CharactersHasProfile'])) {
							$class = 'publicFlagBg';
						}
						echo $this->Html->tag('span', 
							$hasProfile[$key]['CharactersHasProfile']['value'], 
							array(
								'class' => $class,
							)
						);
					} else {
						echo "&nbsp;";
					}
				} else {
					echo "&nbsp;";
				}
			} else {
				echo null;
			}
		} else {
			echo null;
		}
	}

	/* フォーマットして出力 */
	function formatValues($pattern, $replacement)
	{
		if (empty($pattern) || empty($replacement)) {
			echo null;
		}

		$pattern_num = substr_count($pattern, "%");
		$replacement_num = count((array)$replacement);
		if ($pattern_num != $replacement_num) {
			$replacement = array_merge(
				$replacement,
				array_fill($pattern_num, $pattern_num - $replacement_num, "&nbsp;")
			);
		}

		@vprintf($pattern, $replacement);
	}

	/* Time */
	function formatTime($time, $format = 'Y/m/d H:i')
	{
		if (empty($format)) {
			echo $time;
		}


	}
}

