/*!40101 SET NAMES utf8 */;

/* Add Table */

DROP TABLE IF EXISTS `tmp_links`;
DROP TABLE IF EXISTS `links`;

CREATE TABLE `links` (
  `id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL DEFAULT 'NO TITLE',
  `user_id` INTEGER UNSIGNED NOT NULL,
  `url` VARCHAR(512) NOT NULL DEFAULT '',
  `notes` TEXT NOT NULL,
  `type` INT(2) NOT NULL DEFAULT '0',
  `ring` TEXT NOT NULL,
  `pickup` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `not_found` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `modified` DATETIME NULL,
  `created` DATETIME NULL,
  PRIMARY KEY(`id`),
  INDEX `links_user`(`user_id`),
  INDEX `links_modified`(`modified`),
  INDEX `links_type`(`type`, `pickup`, `not_found`),
  INDEX `links_not_found`(`not_found`, `modified`),
  CONSTRAINT `fk_users-links`
    FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) TYPE=InnoDB DEFAULT CHARSET=utf8, COLLATE=utf8_general_ci;

CREATE TABLE `tmp_links` (
  `id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
  `link_id` INTEGER UNSIGNED NOT NULL,
  `url` VARCHAR(512) NOT NULL DEFAULT '',
  `checked` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
  `result` TEXT NOT NULL,
  `created` DATETIME NULL,
  PRIMARY KEY(`id`),
  INDEX `tmp_links_link`(`link_id`),
  INDEX `tmp_links_checked`(`checked`, `created`),
  CONSTRAINT `fk_links-tmp_links`
    FOREIGN KEY (`link_id`) REFERENCES `links` (`id`) ON DELETE CASCADE
) TYPE=InnoDB DEFAULT CHARSET=utf8, COLLATE=utf8_general_ci;

