<?php 
if (!isset($keyword)) {
	$keyword = null;
}

$search_models_num = count($search_cols);
$m = 1;
$isLast = false;

$search_select_options = array();
$search = array();

$display_items = array('name', 'system_id', 'public_flag', 'status');

foreach($search_cols as $model => $settings) {
	$search_cols_num = 0;
	$i = 1;
	if ($m == $search_models_num) {
		$isLast = true;
		$search_cols_num = count($settings);
	}

	foreach ($settings as $field => $options) {
		$fieldname = $model. '.'. 'keyword.'. $field;
		$fieldClass = 'SearchColumn_'. $field;

		$display_style = false;
		if (!in_array($field, $display_items)) {
			$search_select_options[$field] = $options['name'];
			if (!isset($this->data[$model]['keyword'][$field]['value']) || empty($this->data[$model]['keyword'][$field]['value'])) {
				$display_style = 'display:none;';
			}
		}

		$search[$fieldname] = $html->tag('dt',
			$options['name'],
			array(
				'class' => $fieldClass,
				'style' => $display_style,
			)
		);

		unset($options['name']);
		$options['label'] = false;
		$options['legend'] = false;
		$options['div'] = array(
			'class' => 'inline searchType',
		);

		$dd_contents = $form->input($fieldname.'.value', $options);

		if (($field != 'public_flag' && $field != 'system_id' && $field != 'status') && (!$isLast || $i != $search_cols_num)) {
			$dd_contents .=  $form->input($fieldname.'.type', array_merge($options, array(
				'type' => 'radio',
				'options' => array(
					'and' => 'AND',
					'or' => 'OR',
				),
				'default' => 'and'
			)));
		}

		$search[$fieldname] .= $html->tag('dd', 
			$dd_contents,
			array(
				'class' => $fieldClass,
				'style' => $display_style,
			)
		);

		$i++;
	}

	$m++;
}
?>
<div class="characters listview searchDetail">

<div class="box full">
<div class="boxHeader"><h2>
<span><?php __('Search'); ?></span>
<span class="multipleSearchNotice">
<?php __('If you want the Multiple keywords search in one item, devide words by comma.'); ?>
</span>
</h2></div>
<div class="boxBody">
<?php 
echo $form->create('Character', array(
	'url' => array_merge(array(
		'action' => $this->action), $this->passedArgs
	),
	'id' => 'Search',
));
?>
<p>
<dl>
<?php if (!empty($search_select_options)): ?>
<dt><?php __('Search Target') ?></dt>
<dd>
<?php
	echo $form->input('searchSelect', array(
		'type' => 'select',
		'label' => false,
		'id' => 'searchSelect',
		'div' => array('class' => 'inline'),
		'options' => $search_select_options,
	));

	echo $form->button(sprintf('%s/%s', __('Add', true), __('Delete', true)), array(
		'type' => 'button',
		'label' => false,
	));
?>
</dd>
<script language="JavaScript">
<!--
$("button").click(function(){
	var target = $('#searchSelect').val();
	$('.SearchColumn_'+target).toggle();
	if ($('.SearchColumn_'+target).css('display') == 'none' && target != 'public_flag' && target != 'status' && target != 'system_id') {
		$('dd.SearchColumn_'+target+' > div > input').attr('disabled', 'disabled');
	} else {
		$('dd.SearchColumn_'+target+' > div > input').attr('disabled', '');
	}
});
//-->
</script>
<?php endif; ?>

<?php 
echo $form->create('Character', array(
	'url' => array_merge(array(
		'action' => $this->action), $this->passedArgs
	),
	'id' => 'Search',
));
 ?>

<?php foreach($search as $v): ?>
<?php echo $v; ?>
<?php endforeach; ?>

</dl>
</div>
<?php
echo $form->end(__('Search' ,true), array(
	'class' => 'inline',
)); 


echo $form->create('Character', array(
	'url' => array_merge(array(
		'action' => 'index'), $this->passedArgs
	),
	'type' => 'GET',
	'id' => 'CancelButton',
));

echo $form->end(__('Back' ,true), array(
	'class' => 'inline',
)); 
?>

</div>
</div>