/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.controller.DirectorData;
import org.ultramonkey.l7.controller.L7vsAdmData;
import org.ultramonkey.l7.controller.L7vsConfData;
import org.ultramonkey.l7.controller.LogData;
import org.ultramonkey.l7.controller.VirtualSetting;
import org.ultramonkey.l7.model.L7guiFramework;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.Parameter;
import org.ultramonkey.l7.model.UserData;
import org.ultramonkey.l7.model.UserManager;
import org.ultramonkey.l7.view.L7guiServletBase;

public final class LoginServlet
extends L7guiServletBase
implements Servlet {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public LoginServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11279 class LoginServlet created.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("LoginServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11280 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            this.logger.debug((Object)("11281 QueryString=\"" + request.getQueryString() + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11282 LoginServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11283 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11284 PostData=\"" + post + "\""));
        }
        boolean validationFlag = true;
        HttpSession session = request.getSession(true);
        if (session == null) {
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11285 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        request.setCharacterEncoding("UTF-8");
        String userName = request.getParameter("uid");
        String userPass = request.getParameter("passwd");
        if (userName == null || userPass == null) {
            MessageView error = new MessageView(41066, "l7gui_UserManage", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11286 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        validationFlag = this.validationCheck(userName, userPass);
        if (!validationFlag) {
            MessageView error = new MessageView(21039, "l7gui_UserAuthentication", "Invalid \"User ID\" or \"Password\".");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11287 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        UserManager manager = UserManager.getInstance();
        if (manager == null) {
            MessageView error = new MessageView(41067, "l7gui_StartStop", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11288 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        UserData user = manager.authUser(userName, userPass);
        if (user != null) {
            Parameter param = Parameter.getInstance();
            if (param == null) {
                MessageView error = new MessageView(41068, "l7gui_StartStop", "Unexpected error.");
                session.setAttribute("resultMessage", (Object)error);
                response.sendRedirect("index.jsp");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"11289 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                }
                return;
            }
            String sessionTimeout = param.getValue("max_session_time");
            if (sessionTimeout != null) {
                try {
                    session.setMaxInactiveInterval(Integer.parseInt(sessionTimeout));
                }
                catch (Exception e) {
                    MessageView error = new MessageView(41069, "l7gui_StartStop", "Unexpected error.");
                    session.setAttribute("resultMessage", (Object)error);
                    response.sendRedirect("index.jsp");
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"11290 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                    }
                    return;
                }
            }
        } else {
            MessageView error = new MessageView(41070, "l7gui_UserAuthentication", "User Authentication failed.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11291 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        session.setAttribute("onLogin", (Object)user);
        session.setAttribute("logSyncState", (Object)"sync");
        session.setAttribute("vsSyncState", (Object)"sync");
        session.setAttribute("monitorSyncState", (Object)"sync");
        session.setAttribute("repSyncState", (Object)"sync");
        session.setAttribute("snmpSyncState", (Object)"sync");
        session.setAttribute("guiSyncState", (Object)"sync");
        L7guiFramework framework = new L7guiFramework();
        L7vsAdmData admDataList = framework.getAdmData();
        DirectorData directorData = framework.getDirectorData();
        L7vsConfData confData = framework.getL7vsConfData();
        if (admDataList == null || directorData == null || confData == null) {
            MessageView error = new MessageView(41071, "l7gui_I/O", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11292 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        boolean vsSave = false;
        if (admDataList.virtualSettings.size() == directorData.virtualSettings.size()) {
            int i = 0;
            while (i < admDataList.virtualSettings.size()) {
                VirtualSetting admVs = admDataList.virtualSettings.elementAt(i);
                int j = 0;
                while (j < directorData.virtualSettings.size()) {
                    VirtualSetting directorVs = directorData.virtualSettings.elementAt(j);
                    vsSave = directorVs.equalsAdm(admVs);
                    if (vsSave) break;
                    ++j;
                }
                if (!vsSave) break;
                ++i;
            }
            if (admDataList.virtualSettings.size() == 0) {
                vsSave = true;
            }
        }
        if (vsSave) {
            session.setAttribute("vsSaveState", (Object)"save");
        } else {
            session.setAttribute("vsSaveState", (Object)"noSave");
        }
        try {
            boolean logL7vsdSave = true;
            boolean logSnmpSave = true;
            HashMap<LogData.LogCategory, LogData.LogLevel> admL7vsdLogLevel = admDataList.l7vsdLogLevel;
            HashMap<LogData.LogCategory, LogData.LogLevel> confL7vsdLogLevel = confData.logger.lbLog.logLevel;
            logL7vsdSave = admL7vsdLogLevel.equals(confL7vsdLogLevel);
            HashMap<LogData.LogCategory, LogData.LogLevel> admSnmpLogLevel = admDataList.snmpLogLevel;
            HashMap<LogData.LogCategory, LogData.LogLevel> confSnmpLogLevel = confData.logger.snmpLog.logLevel;
            logSnmpSave = admSnmpLogLevel.equals(confSnmpLogLevel);
            if (logL7vsdSave && logSnmpSave) {
                session.setAttribute("logSaveState", (Object)"save");
            } else {
                session.setAttribute("logSaveState", (Object)"noSave");
            }
        }
        catch (NullPointerException e) {
            MessageView error = new MessageView(41072, "l7gui_UserManage", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11293 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        response.sendRedirect("top.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11294 LoginServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    private boolean validationCheck(String userName, String userPass) {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("LoginServlet::validationCheck(String userName, String userPass) in ");
            buf.append("userName=\"" + userName + "\", ");
            buf.append("userPass=\"" + userPass + "\"");
            this.logger.debug((Object)("11295 " + buf.toString()));
        }
        boolean validationFlag = true;
        boolean MIN_LENGTH = true;
        int MAX_LENGTH = 16;
        int MIN_PASS_LENGTH = 6;
        if (userName.length() < 1 || userName.length() > 16) {
            validationFlag = false;
        } else if (userPass.length() < 6 || userPass.length() > 16) {
            validationFlag = false;
        } else {
            Pattern pattern = Pattern.compile("([^\\x20-\\x7e])");
            Matcher userNameMatcher = pattern.matcher(userName);
            Matcher userPassMatcher = pattern.matcher(userPass);
            if (userNameMatcher.find() || userPassMatcher.find()) {
                validationFlag = false;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("11296 LoginServlet::validationCheck(String userName, String userPass) out return=" + validationFlag));
        }
        return validationFlag;
    }
}

