/*
 * Decompiled with CFR 0.152.
 */
package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.FileNotWriteException;
import org.ultramonkey.l7.model.MessageView;
import org.ultramonkey.l7.model.UserData;
import org.ultramonkey.l7.model.UserManager;
import org.ultramonkey.l7.view.L7guiServletBase;

public class UserRemoveServlet
extends L7guiServletBase {
    static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger((String)"l7gui_I/O");

    public UserRemoveServlet() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11443 class UserModServlet created.");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11444 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            this.logger.debug((Object)("11445 QueryString=\"" + request.getQueryString() + "\""));
        }
        response.sendRedirect("index.jsp");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11446 UserModServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            this.logger.debug((Object)("11447 " + buf.toString()));
            request.setCharacterEncoding("UTF-8");
            Enumeration keys = request.getParameterNames();
            String post = "";
            while (keys.hasMoreElements()) {
                if (post.length() != 0) {
                    post = String.valueOf(post) + "&";
                }
                String key = (String)keys.nextElement();
                post = String.valueOf(post) + key + "=" + request.getParameter(key);
            }
            this.logger.debug((Object)("11448 PostData=\"" + post + "\""));
        }
        super.doPost(request, response);
        HttpSession session = request.getSession(false);
        if (!this.login || session == null) {
            if (session != null) {
                MessageView error = new MessageView(41194, "l7gui_UserAuthentication", "Invalid session.");
                session.setAttribute("resultMessage", (Object)error);
            }
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11449 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        UserData currentUser = (UserData)session.getAttribute("onLogin");
        if (currentUser == null) {
            MessageView error = new MessageView(41195, "l7gui_UserAuthentication", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11450 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        request.setCharacterEncoding("UTF-8");
        String[] selectCheck = request.getParameterValues("ck_user");
        String button_mode = request.getParameter("button");
        if (button_mode == null || !button_mode.equals("Delete")) {
            MessageView error = new MessageView(41196, "l7gui_UserManage", "Unexpected error.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("index.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11451 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        if (selectCheck == null) {
            MessageView error = new MessageView(21086, "l7gui_UserManage", "Please select one or some of the followings.");
            session.setAttribute("resultMessage", (Object)error);
            response.sendRedirect("user_manage.jsp");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"11452 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
            }
            return;
        }
        UserManager user = UserManager.getInstance();
        boolean removeUser = true;
        boolean removeFlag = true;
        String successRemoveUser = "";
        String failRemoveUser = "";
        int i = 0;
        while (i < selectCheck.length) {
            if (selectCheck[i].equals(currentUser.userName)) {
                MessageView error = new MessageView(21087, "l7gui_UserManage", "Cannot delete yourself.");
                session.setAttribute("resultMessage", (Object)error);
                response.sendRedirect("user_manage.jsp");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"11453 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                }
                return;
            }
            ++i;
        }
        i = 0;
        while (i < selectCheck.length) {
            try {
                removeUser = user.delUser(selectCheck[i]);
            }
            catch (FileNotWriteException e) {
                MessageView error = new MessageView(41197, "l7gui_I/O.File", "Cannot write file.");
                session.setAttribute("resultMessage", (Object)error);
                response.sendRedirect("index.jsp");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"11454 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                }
                return;
            }
            catch (Exception e) {
                MessageView error = new MessageView(41198, "l7gui_UserAuthentication", "Unexpected error.");
                session.setAttribute("resultMessage", (Object)error);
                response.sendRedirect("index.jsp");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"11455 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
                }
                return;
            }
            if (removeUser) {
                successRemoveUser = String.valueOf(successRemoveUser) + selectCheck[i] + " ";
            } else {
                removeFlag = false;
                failRemoveUser = String.valueOf(failRemoveUser) + selectCheck[i] + " ";
            }
            ++i;
        }
        if (removeFlag) {
            MessageView message = new MessageView(21088, "l7gui_UserManage", "UserName : " + successRemoveUser + "User deleted.");
            session.setAttribute("resultMessage", (Object)message);
            session.setAttribute("guiSyncState", (Object)"noSync");
            response.sendRedirect("user_manage.jsp");
        } else {
            if (successRemoveUser.length() != 0) {
                MessageView error = new MessageView(21089, "l7gui_UserManage", "UserName : " + successRemoveUser + "User deleted." + "<br />\n" + "UserName : " + failRemoveUser + "Failed to delete user.");
                session.setAttribute("resultMessage", (Object)error);
            } else {
                MessageView message = new MessageView(41199, "l7gui_UserManage", "UserName : " + failRemoveUser + "Failed to delete user.");
                session.setAttribute("resultMessage", (Object)message);
            }
            response.sendRedirect("user_delete_fail.jsp");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"11456 UserModServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
        }
    }
}

