<%@ page
	import="org.ultramonkey.l7.model.*,org.ultramonkey.l7.controller.*,org.ultramonkey.l7.view.*"
	language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>

<%
	 /*
	 * check session
	 */
	L7guiServletBase base = new L7guiServletBase();
	if (session.isNew() || base.checkSession(session) == false) {
		MessageView error = new MessageView(41345,
		LogCategorySet.GUI_USER_AUTHENTICATION,
		Message.INVALID_SESSSION);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get thread status
	 */
	String threadStatus = (String) session
			.getAttribute(SessionKeys.THREAD_STATUS);
	if (threadStatus == null) {
		MessageView error = new MessageView(41346,
		LogCategorySet.GUI_REPLICATION,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	} else if (threadStatus.equals(SessionKeys.THREAD_RUNNING)) {
		//
	} else if (threadStatus.equals(SessionKeys.THREAD_SUCCESS)) {
		response.sendRedirect(RedirectPages.REPLICATION_INFO);
		return;
	} else if (threadStatus.equals(SessionKeys.THREAD_FAIL)) {
		response.sendRedirect(RedirectPages.REPLICATION_MODE_NG);
		return;
	} else {
		MessageView error = new MessageView(41347,
		LogCategorySet.GUI_REPLICATION,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	/*
	 * get Replication Status
	 */
	L7guiFramework framework = new L7guiFramework();
	ReplicationData rep = framework.getReplicationData();
	if (rep == null) {
		MessageView error = new MessageView(41348,
		LogCategorySet.GUI_REPLICATION,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}

	ReplicationStatus repStatus = rep.replicationMode;
	String repChangeStatus = "";
	String repNowStatus = "";
	
	switch (repStatus) {
	case MASTER:
		repNowStatus = "Master Run";
		repChangeStatus = "Master Stop";
		break;
	case MASTER_STOP:
		repNowStatus = "Master Stop";
		repChangeStatus = "Master Run";
		break;
	case SLAVE:
		repNowStatus = "Slave Run";
		repChangeStatus = "Slave Stop";
		break;
	case SLAVE_STOP:
		repNowStatus = "Slave Stop";
		repChangeStatus = "Slave Run";
		break;
	default:
		MessageView error = new MessageView(41349,
		LogCategorySet.GUI_REPLICATION,
		Message.UNEXPECTED_ERROR);
		session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
		response.sendRedirect(RedirectPages.LOGIN);
		return;
	}
%>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Cache-Control" content="no-cache">
	<meta http-equiv="Expires" content="0"> 		
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="refresh" content="<%= RedirectPages.REFRESH_TIME %>" />
	<noscript>
	<meta http-equiv="refresh"
		content="<%= RedirectPages.NOSCRIPT_TIME %>; url=<%= RedirectPages.LOGIN %>" />
	</noscript>
	
	<link rel="stylesheet" type="text/css" href="l7gui_basic_style.css" />
	<link rel="shortcut icon" href="images/favicon.ico" />
	<title>Changing : Replication Mode</title>
</head>
<body>
<h1 class="title">Changing : Replication Mode</h1>
<h2>Please wait.</h2>
<h3><%=repNowStatus%></h3>

<img class="arrow1" src="images/arrowlogo1.gif" alt="arrowlogo1" />

<h3><%=repChangeStatus%></h3>
</body>
</html>

