package org.ultramonkey.l7.controller;

import java.io.Serializable;
import java.util.HashMap;

/**
 * <p>class L7vsConfData</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author nakai
 */
public class L7vsConfData implements Serializable {
    static final long serialVersionUID = 1L;

    /**
     * l7vs.cf value of "[replication] nic"
     */
    public String replicationNic;

    /**
     * l7vs.cf value of "[replication] interval"
     */
    public int replicationInterval;

    /**
     * l7vs.cf value of "[replication] ip_addr, service_name"
     */
    public EndPoint replicationOtherNode;

    /**
     * l7vs.cf value of "[replication] component_xx" settings
     */
    public HashMap<String, Integer> component;

    /**
     * l7vs.cf value of "[snmpagent] interval"
     */
    public int snmpInterval;

    /**
     * l7vs.cf value of "[snmpagent] nic"
     */
    public String snmpNIC;

    /**
     * l7vs.cf value of "[snmpagent] ip_addr"
     */
    public String snmpIpAddr;

    /**
     * l7vs.cf value of "[snmpagent] port"
     */
    public String snmpPort;

    /**
     * l7vs.cf value of "[logger]" category settings.
     */
    public LogData logger;

    /**
     * l7vs.cf value of "[l7vsadm] cmd_interval"
     */
    public int admCmdInterval;

    /**
     * l7vs.cf value of "[l7vsadm] cmd_count"
     */
    public int admCmdCount;;

    /**
     * l7vs.cf value of "[l7vsadm] con_interval"
     */
    public int admConInterval;

    /**
     * l7vs.cf value of "[l7vsadm] con_count"
     */
    public int admConCount;

    /**
     * 
     * Constructor
     *
     */
    public L7vsConfData() {
        this.replicationOtherNode = new EndPoint();
        this.logger = new LogData();
    }
}
