﻿package org.ultramonkey.l7.model;

import java.util.HashSet;

import org.apache.log4j.Logger;

/**
 * <p>class L7SyncCommand</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author momose
 */
public class L7SyncCommand {
    protected static Logger debugLogger = Logger.getLogger(LogCategorySet.SYNC_SYNC);

    protected HashSet<Integer> categorySet;

    protected int serverMode = 0;

    private static final int ACT_MODE = 1;

    private static final int SBY_MODE = 2;

    private static final int MODE_ERROR = 3;

    private static final int UNDESIGNED_MODE = 0;

    private int MODE_LOCATION = 0;

    private int CATEGORY_START_LOCATION = MODE_LOCATION + 1;

    protected Logger logger = Logger.getLogger(LogCategorySet.SYNC_SYNC);

    /**
     * Constructor
     *
     * @param args
     */
    public L7SyncCommand(String[] args) {
        //      debug log(constructor)
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("11232 class L7SyncCommand created.");
        }

        categorySet = new HashSet<Integer>();
        try {
            this.checkArgument(args);
        } catch (MessageView m) {
            System.out.println(Message.SYNC_INVALID_ARGUMENT + " L7SyncCommand.");
            logger.info("21032 " + Message.SYNC_INVALID_ARGUMENT + " L7SyncCommand.");
        }
    }

    /**
     * <p> checks arguments</p>
     *
     * @param args argument value from command line
     * @throws MessageView
     */
    protected void checkArgument(String[] args) throws MessageView {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf
                            .append("L7SyncCommand::checkArgument(String[] args) throws MessageView in args= ");
            if (0 != args.length) {
                for (int i = 0; i < args.length; i++) {
                    if (args.length - 1 == i) {
                        buf.append(args[i].toString());
                        break;
                    }
                    buf.append(args[i].toString() + ",");
                }
            } else {
                buf.append("null");
            }
            debugLogger.debug("11233 " + buf.toString());
        }

        if (0 == args.length) {
            setServerMode(UNDESIGNED_MODE);
        } else if (args[MODE_LOCATION].equals("-a")) {
            setServerMode(ACT_MODE);
            if (args.length <= CATEGORY_START_LOCATION) {
                throw new MessageView(40024, LogCategorySet.SYNC_SYNC,
                                Message.SYNC_INVALID_ARGUMENT + " checkArgument.");
            }
            for (int i = CATEGORY_START_LOCATION; i < args.length; i++) {
                try {
                    setCaterogyIdSet(SyncCategoryIdSet.toCategoryId(args[i]));
                } catch (MessageView m) {
                    throw new MessageView(40025, LogCategorySet.SYNC_SYNC,
                                    Message.SYNC_INVALID_ARGUMENT + " checkArgument.");
                }
            }
        } else if (args[MODE_LOCATION].equals("-s")) {
            setServerMode(SBY_MODE);
        } else {
            setServerMode(MODE_ERROR);
            throw new MessageView(40026, LogCategorySet.SYNC_SYNC,
                            Message.SYNC_INVALID_ARGUMENT + " checkArgument.");
        }

        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf
                            .append("L7SyncCommand::checkArgument(String[] args) throws MessageView out ");
            debugLogger.debug("11234 " + buf.toString());
        }

    }

    /**
     * <p> starts L7GUI synchronous processing</p>
     *
     * @param args
     */
    public static void main(String[] args) {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::main(String[] args) in args= ");
            if (0 == args.length) {
                buf.append("null");
            } else {
                for (int i = 0; i < args.length; i++) {
                    if (args.length - 1 == i) {
                        buf.append(args[i].toString());
                        break;
                    }
                    buf.append(args[i].toString() + ",");
                }
            }
            debugLogger.debug("11235 " + buf.toString());
        }

        if (0 == args.length) {
            L7SyncCommand.usage();

        } else {
            L7SyncCommand l7SyncCommand = new L7SyncCommand(args);
            l7SyncCommand.start();
        }
        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::main(String[] args) out ");
            debugLogger.debug("11236 " + buf.toString());
        }

    }

    /**
     * <p> starts active or stand-by processing</p>
     *
     */
    protected void start() {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::start() in ");
            debugLogger.debug("11237 " + buf.toString());
        }

        L7SyncManager l7SyncManager = new L7SyncManager();
        switch (serverMode) {
        case ACT_MODE:
            try {
                l7SyncManager.syncAct(getCategoryIdSet());
            } catch (MessageView m) {
                System.out.println(m.message);
            }
            break;

        case SBY_MODE:
            try {
                l7SyncManager.syncSby();
            } catch (MessageView m) {
                System.out.println(m.message);
            }
            break;
        default:
            System.out.println(Message.SYNC_INVALID_SERVER_MODE);
            break;
        }
        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::start() out ");
            debugLogger.debug("11238 " + buf.toString());
        }

    }

    /**
     * <p> shows how to use L7SyncCommand</p>
     *
     */
    protected static void usage() {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::usage() in ");
            debugLogger.debug("11239 " + buf.toString());
        }

        System.out.println(
        		"Usage: L7SyncCommand -a [CATEGORY]...\n" +
        		"       L7SyncCommand -s\n" +
        		"\n" +
        		"Commands:\n" +
        		"  -a    active mode. send specified category data to standby server.\n" +
        		"  -s    standby mode. receive data from active server.\n" +
        		"\n" +
        		"Category:\n" +
        		"  l7vsd_log         log settings of l7vsd\n" +
        		"  adm_log           log settings of l7vsadm\n" +
        		"  snmp_log          log settings of l7agent\n" +
        		"  log_all           all log settings\n" +
        		"  adm_info          command settings of l7vsadm\n" +
        		"  replication_info  replication settings of l7vsd\n" +
        		"  snmp_info         interval settings of l7agent\n" +
        		"  monitor           global settings of l7directord.cf\n" +
        		"  service           virtual settings of l7directord.cf\n" +
        		"  userdata          user data of l7gui\n"
        		);

        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::usage() out ");
            debugLogger.debug("11240 " + buf.toString());
        }

    }

    /**
     * <p> gets CategoryIdSet</p>
     *
     * @return categorySet
     */
    protected HashSet<Integer> getCategoryIdSet() {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::getCategoryIdSet() in ");
            debugLogger.debug("11241 " + buf.toString());
        }

        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::getCategoryIdSet() out ");
            buf.append("return= " + categorySet.toString());
            debugLogger.debug("11242 " + buf.toString());
        }

        return categorySet;
    }

    /**
     * <p> sets CaterogyIdSet</p>
     *
     * @param categoryId
     */
    protected void setCaterogyIdSet(Integer categoryId) {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::setCaterogyIdSet() in ");
            debugLogger.debug("11243 " + buf.toString());
        }
        categorySet.add(categoryId);

        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::setCaterogyIdSet() out ");
            debugLogger.debug("11244 " + buf.toString());
        }
    }

    /**
     * <p> gets serverMode</p>
     *
     * @return
     */
    protected int getServerMode() {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::getServerMode() in ");
            debugLogger.debug("11245 " + buf.toString());
        }
        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::getServerMode() out ");
            buf.append("return= " + serverMode);
            debugLogger.debug("11246 " + buf.toString());
        }
        return serverMode;
    }

    /**
     * <p> sets serverMode</p>
     *
     * @param mode
     */
    protected void setServerMode(int mode) {
        //      debug log(in method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::setServerMode() in ");
            buf.append("mode= " + mode);
            debugLogger.debug("11247 " + buf.toString());
        }
        //      debug log(out method)
        if (debugLogger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("L7SyncCommand::getServerMode() out ");
            debugLogger.debug("11248 " + buf.toString());
        }
        serverMode = mode;
    }
}
