package org.ultramonkey.l7.model;

import java.io.Serializable;

import org.apache.log4j.Logger;

/**
 * 
 * <p>class MessageView</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * @author tanuma
 */
public class MessageView extends Throwable implements Serializable {
    static final long serialVersionUID = 1L;

    private Logger ioLogger = Logger.getLogger(LogCategorySet.GUI_IO);
	private Logger logger = Logger.getLogger(LogCategorySet.GUI_LOG);

	protected String message = "";
    protected int errno = 0;
    protected String category = "";

    /**
     * 
     * Constructor
     *
     * @param errno
     * @param category
     * @param message
     */
    public MessageView(int errno, String category, String message) {
        // --- debug log (constructor) ---
        if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11085 class MessageView created.");
        }
        // --- debug log (constructor) ---
    	
    	if (message != null)
    		this.message = new String(message);
        if (category != null) 
        	this.category = new String(category);
        this.errno = errno;
        
        putLog();
    }

    /**
     * 
     * Constructor
     *
     */
    public MessageView() {
        // --- debug log (constructor) ---
        if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11086 class MessageView created.");
        }
        // --- debug log (constructor) ---
    }

    /**
     * 
     * <p> getMessage method</p>
     * 
     * @return
     */
    public String getMessage() {
		// --- debug log (in/out method) ---
		if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11087 MessageView::getMessage() in");
            ioLogger.debug("11088 MessageView::getMessage() out return=\"" + this.message + "\"");
		}
		// --- debug log (in/out method) ---
        return this.message;
    }

    /**
     * 
     * <p> setMessage method</p>
     *
     * @param message
     */
    public void setMessage(String message) {
		// --- debug log (in method) ---
		if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11089 MessageView::setMessage(String message) in message=\"" + message + "\"");
		}
		// --- debug log (in method) ---

		this.message = message;
    	putLog();

    	// --- debug log (out method) ---
		if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11090 MessageView::setMessage(String message) out");
		}
		// --- debug log (out method) ---
    }

    /**
     * 
     * <p> getErrno method</p>
     *
     * @return
     */
    public int getErrno() {
		// --- debug log (in/out method) ---
		if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11091 MessageView::getErrno() in");
            ioLogger.debug("11092 MessageView::getErrno() out return=\"" + this.errno + "\"");
		}
		// --- debug log (in/out method) ---
        return this.errno;
    }

    /**
     * 
     * <p> setErrno method</p>
     *
     * @param errno
     */
    public void setErrno(int errno) {
		// --- debug log (in method) ---
		if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11093 MessageView::setErrno(int errno) in errno=" + errno);
		}
		// --- debug log (in method) ---

        this.errno = errno;

        // --- debug log (out method) ---
		if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11094 MessageView::setErrno(int errno) out");
		}
		// --- debug log (out method) ---
    }

    /**
     * 
     * <p> getCategory method</p>
     *
     * @return
     */
    public String getCategory() {
		// --- debug log (in/out method) ---
		if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11095 MessageView::getCategory() in");
            ioLogger.debug("11096 MessageView::getCategory() out return=\"" + this.category + "\"");
		}
		// --- debug log (in/out method) ---
        return this.category;
    }

    /**
     * 
     * <p> setCategory method</p>
     *
     * @param category
     */
    public void setCategory(String category) {
		// --- debug log (in method) ---
		if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11097 MessageView::setMessage(String category) in category=\"" + category + "\"");
		}
		// --- debug log (in method) ---

    	this.category = category;

    	// --- debug log (out method) ---
		if (ioLogger.isDebugEnabled()) {
            ioLogger.debug("11098 MessageView::setMessage(String category) out");
		}
		// --- debug log (out method) ---
    }
    
    /**
     * 
     * <p> putLog method</p>
     *
     */
    protected void putLog() {
        // --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11099 MessageView::putLog() in");
		}
		// --- debug log (in method) ---

		if (this.message != null && this.category != null && this.errno >= 10000) {
        	Logger logger = Logger.getLogger(this.category);
        	if (this.errno < 20000) {
        		logger.debug(this.errno + " " + this.message);
        	} else if (this.errno < 30000) {
        		logger.info(this.errno + " " + this.message);
        	} else if (this.errno < 40000) {
        		logger.warn(this.errno + " " + this.message);
        	} else if (this.errno < 50000) {
        		logger.error(this.errno + " " + this.message);
        	} else if (this.errno < 60000) {
        		logger.fatal(this.errno + " " + this.message);
        	}
        }
        // --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11100 MessageView::putLog() out");
		}
		// --- debug log (out method) ---
    }
    
    public String toString() {
    	return 
			"message=\"" + this.message + "\", " +
			"errno=" + this.errno + ", " +
			"category=\"" + this.category + "\"";
    }
}
