package org.ultramonkey.l7.view;

import java.io.IOException;
import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.*;

/**
 * servlet base class
 * 
 * @author nakai
 * @version 1.0
 * @since 1.0
 */
public class L7guiServletBase extends HttpServlet {
	static final long serialVersionUID = 1L;
	protected static final String USERPARAM = "uid"; 
	protected static final String PASSWDPARAM = "passwd";
	protected boolean login = false;

	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);
	
	public L7guiServletBase() {
		super();

		// --- debug log (constructor) ---
        if (logger.isDebugEnabled()) {
            logger.debug("11339 class L7guiServletBase created.");
        }
        // --- debug log (constructor) ---
	}
	
	/* (non-Java-doc)
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("L7guiServletBase::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11340 " + buf.toString());
		}
		// --- debug log (in method) ---

		doPost(request, response);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11341 L7guiServletBase::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
	}

	/* (non-Java-doc)
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 * 
	 * ex. child class
	 * 	 public class childServlet extends L7guiServletBase {
	 * 	 	protected void doPost(HttpServletRequest req, HttpServletResponse res) {
	 * 	 		super.doPost(req, res);
	 * 	 		if ( login == false ) return;
	 * 	 				:
	 * 	 				:
	 * 	 				:
	 * 	 	}
	 * 	 }
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("L7guiServletBase::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11342 " + buf.toString());
		}
		// --- debug log (in method) ---

		HttpSession session = request.getSession(false);
		login = this.checkSession(session);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11343 L7guiServletBase::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
	}

	/*
	 * 
	 * <p> checkSession method</p>
	 *
	 * @param session
	 * @return
	 */
	public boolean checkSession(HttpSession session){
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("L7guiServletBase::checkSession(HttpSession session) in ");
            buf.append("session=(" + session + ")");
            logger.debug("11344 " + buf.toString());
		}
		// --- debug log (in method) ---

		// session check.
		if (session == null) {
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11345 L7guiServletBase::checkSession(HttpSession session) out return=false");
			}
			// --- debug log (out method) ---
			return false;
		}
		
		UserData sessionUserData = (UserData) session.getAttribute(SessionKeys.LOGIN_SESSION);
		UserManager userManager = UserManager.getInstance();
		
		try {
			UserData serverUserData = userManager.authUser(sessionUserData.userName, sessionUserData.passwd);
			if (serverUserData == null) {
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11346 L7guiServletBase::checkSession(HttpSession session) out return=false");
				}
				// --- debug log (out method) ---
				return false;
			}
		} catch (NullPointerException e) {
			logger.error("41086 Exception occured: " + e.getMessage());
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11347 L7guiServletBase::checkSession(HttpSession session) out return=false");
			}
			// --- debug log (out method) ---
			return false;
		}

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11348 L7guiServletBase::checkSession(HttpSession session) out return=true");
		}
		// --- debug log (out method) ---
		return true;
	}
}
