package org.ultramonkey.l7.view;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.log4j.Logger;
import org.ultramonkey.l7.model.*;


/**
 * 
 * <p>class SoRunServlet</p>
 * <p>Copyright(c) NTT COMWARE 2008</p>
 * <p>Servlet implementation class for Servlet: SoRun</p>
 * @author kubota
 */
public class SoRunServlet extends L7guiServletBase {
	static final long serialVersionUID = 1L;	
	
	private Logger logger = Logger.getLogger(LogCategorySet.GUI_IO);

	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public SoRunServlet() {
		super();
        // --- debug log (constructor) ---
		if (logger.isDebugEnabled()) {
			logger.debug("11311 class SoRunServlet created.");
		}
		// --- debug log (constructor) ---
	}  
 	
	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) 
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("SoRunServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11312 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			logger.debug("11313 QueryString=\"" + request.getQueryString() + "\"");
		}
		// --- debug log (in method) ---

		response.sendRedirect(RedirectPages.LOGIN);

		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11314 SoRunServlet::doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}  	

	
	/* (non-Java-doc)
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
		throws ServletException, IOException {
		// --- debug log (in method) ---
		if (logger.isDebugEnabled()) {
			StringBuffer buf = new StringBuffer();
            buf.append("SoRunServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException in ");
            buf.append("request=(" + request + "), ");
            buf.append("response=(" + response + ")");
            logger.debug("11315 " + buf.toString());
            request.setCharacterEncoding("UTF-8");
			Enumeration keys = request.getParameterNames();
			String post = "";
			while (keys.hasMoreElements()) {
				if (post.length() != 0)
					post += "&";
				String key = (String) keys.nextElement();
				post += key + "=" + request.getParameter(key);
			}
			logger.debug("11316 PostData=\"" + post + "\"");
		}
		// --- debug log (in method) ---
		
		// check login session
		super.doPost(request, response);
		
		HttpSession session = request.getSession(false);
		if (login == false || session == null) {
			if (session != null) {
				MessageView error = new MessageView(41077, LogCategorySet.GUI_USER_AUTHENTICATION, Message.INVALID_SESSSION);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			}
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11317 SoRunServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
		
        request.setCharacterEncoding("UTF-8");
		String buttonMode = request.getParameter("button");
		if ((buttonMode != null) && (buttonMode.equals(ButtonMode.SWITCH_OVER))) {
			CommandExecuter thread = new CommandExecuter(session);
			try {
				thread.setExecute(ExecuteMode.CLUSTER_SWITCHORVER);
				thread.start();
			}
			catch(Exception e) {
				MessageView error = new MessageView(41078, LogCategorySet.GUI_REDUNDANT, Message.UNEXPECTED_ERROR);
				session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
				response.sendRedirect(RedirectPages.LOGIN);
				// --- debug log (out method) ---
				if (logger.isDebugEnabled()) {
		            logger.debug("11318 SoRunServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
				}
				// --- debug log (out method) ---
				return;
			}
		}
		else {
			MessageView error = new MessageView(41079, LogCategorySet.GUI_REDUNDANT, Message.UNEXPECTED_ERROR);
			session.setAttribute(SessionKeys.RESULT_MESSAGE, error);
			response.sendRedirect(RedirectPages.LOGIN);
			// --- debug log (out method) ---
			if (logger.isDebugEnabled()) {
	            logger.debug("11319 SoRunServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
			}
			// --- debug log (out method) ---
			return;
		}
	
		response.sendRedirect(RedirectPages.SO_EXECUTIVE);
		// --- debug log (out method) ---
		if (logger.isDebugEnabled()) {
            logger.debug("11320 SoRunServlet::doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException out");
		}
		// --- debug log (out method) ---
		return;
	}	   	  	    
}