/*
 * @file  module_sslid_hash.h
 * @brief sslid hashmap container wrapper.
 * @brief this module provide session persistence by SSL session ID.
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2008  NTT COMWARE Corporation.
 * Copyright (C) 2009  Shinya TAKEBAYASHI
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#ifndef __MODULE_SSLID_HASH_H_8507CFEA_9D4D_4C6A_9E9C_300AD5340ED8__
#define __MODULE_SSLID_HASH_H_8507CFEA_9D4D_4C6A_9E9C_300AD5340ED8__

extern "C" void hash_add(const char*, struct l7vs_dest);
extern "C" int hash_search(const char *, struct l7vs_dest**);

extern "C" void hash_allocate(unsigned int);
extern "C" void hash_destroy(void);
  
extern "C" void *hash_getIDMAP(void);
extern "C" void *hash_getIDLIST(void);
extern "C" int hash_getLISTSIZE(void);
extern "C" void hash_setPointer(const void *, const void*, unsigned int);

extern "C" void hash_construct_sessionlist(struct l7vs_sslid_service*);
extern "C" void hash_rebuild_sessionlist(struct l7vs_sslid_service*);

#endif // __MODULE_SSLID_HASH_H_8507CFEA_9D4D_4C6A_9E9C_300AD5340ED8__
