/*
 * @file  module_sslid_hash.cpp
 * @brief sslid hashmap container wrapper.
 * @brief this module provide session persistence by SSL session ID.
 *
 * L7VSD: Linux Virtual Server for Layer7 Load Balancing
 * Copyright (C) 2008  NTT COMWARE Corporation.
 * Copyright (C) 2009  Shinya TAKEBAYASHI
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 **********************************************************************/

#include <list>
#include <string>
#include <tr1/unordered_map>
#include "l7vs_dest.h"
#include "module_sslid_hash.h"
#include "module_sslid_hash_map.h"

static CSSLIDMap idmap;

void hash_setPointer(const void *keymap, const void *keylist, unsigned int size)
{
  idmap.setPointer((IDLIST *)keymap, (IDLIST *)keylist, size);
}


void hash_add(const char *key, struct l7vs_dest data)
{
  idmap.add(key, data);
}


int hash_search(const char *key, struct l7vs_dest **data)
{
  struct l7vs_dest *tmpdata;
  int retval;
  bool retval_boolean;

  retval_boolean = idmap.search(key, &tmpdata);
  
  if (true == retval_boolean) {
    *data = tmpdata;
    retval = 0;

  } else {
    retval = -1;

  }

  return retval;
}


void hash_allocate(unsigned int size)
{
  idmap.allocate(size);
}


void hash_destroy(void)
{
  idmap.destroy();
}

  
void *hash_getIDMAP(void)
{
  return idmap.getIDMAP();
}


void *hash_getIDLIST(void)
{
  return idmap.getIDLIST();
}


int hash_getLISTSIZE(void)
{
  idmap.getLISTSIZE();
}


void hash_construct_sessionlist(struct l7vs_sslid_service* sslid_service)
{
  idmap.construct_sessionlist(sslid_service);
}


void hash_rebuild_sessionlist(struct l7vs_sslid_service* sslid_service)
{
  idmap.rebuild_sessionlist(sslid_service);
}
