﻿Imports systembase.table

Public Class Sample2

    Private Sub Sample2_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim rp As New UTable.CRecordProvider
        With New CLayoutBuilder(CLayoutBuilder.EOrientation.ROW)
            With rp.AddField("caption", New CCaptionFieldProvider(), .Next(3, 1))
                .Setting.HorizontalAlignment = UTableEx.EHAlign.MIDDLE
            End With

            rp.AddField("denpyo_no", New CTextFieldProvider("伝票番号"), .Break.Next)
            rp.AddField("mitsumori_no", New CTextFieldProvider("見積番号"), .Next)
            rp.AddField("mitsumori_search", New CButtonFieldProvider("見積検索", "見積検索"), .Next)

            .Break.Ascend()
            rp.AddField("torihiki_kbn", New CTextFieldProvider("取引区分"), .Next).MergeCaption = "torihiki_nm"
            rp.AddField("torihiki_nm", New CTextFieldProvider(), .Next).CreateCaption = False
            .Descend()

            rp.AddField("juchubi", New CTextFieldProvider("受注日"), .Next(1, 2))
            rp.AddField("noki", New CTextFieldProvider("納期"), .Next(1, 2))

            .Break(2).Ascend()
            rp.AddField("tokuisaki", New CTextFieldProvider("得意先"), .Next).MergeCaption = "tokuisaki_nm"
            rp.AddField("tokuisaki_nm", New CTextFieldProvider(), .Next).CreateCaption = False
            .Descend()

            .Ascend()
            rp.AddField("seikyusaki", New CTextFieldProvider("請求先"), .Next).MergeCaption = "seikyusaki_nm"
            rp.AddField("seikyusaki_nm", New CTextFieldProvider(), .Next).CreateCaption = False
            .Descend()

            .Ascend()
            rp.AddField("nounyusaki", New CTextFieldProvider("納入先"), .Next).MergeCaption = "nounyusaki_nm"
            rp.AddField("nounyusaki_nm", New CTextFieldProvider(), .Next).CreateCaption = False
            .Descend()

            .Break(2).Ascend()
            rp.AddField("tanto", New CTextFieldProvider("担当者"), .Next).MergeCaption = "tanto_nm"
            rp.AddField("tanto_nm", New CTextFieldProvider(), .Next).CreateCaption = False
            .Descend()

            .Ascend()
            rp.AddField("bumon", New CTextFieldProvider("部門"), .Next).MergeCaption = "bumon_nm"
            rp.AddField("bumon_nm", New CTextFieldProvider(), .Next).CreateCaption = False
            .Descend()

            .Ascend()
            rp.AddField("soko", New CTextFieldProvider("倉庫"), .Next).MergeCaption = "soko_nm"
            rp.AddField("soko_nm", New CTextFieldProvider(), .Next).CreateCaption = False
            .Descend()

            rp.AddField("biko", New CTextFieldProvider("備考"), .Break(2).Next(3, 1))
        End With
        Me.Table.Content.SetRecordProvider(rp)
        Me.Table.CreateCaption()
        Me.Table.FixedCols = 1
        Me.Table.Cols.SetSize(30, 80, 30, 50, 50, 100, 50, 80, 100)
        Using Me.Table.RenderBlock
            For i As Integer = 1 To 20
                Me.Table.Content.AddRecord().Fields("caption").Value = i
            Next
        End Using
    End Sub

    Private Sub UTable_InitializeEditor(ByVal field As UTableEx.CField, ByVal editor As systembase.table.IEditor) Handles Table.InitializeEditor
        If field.Key.Equals("biko") Then
            CType(editor, TextBox).Multiline = True
        End If
    End Sub
End Class

