﻿Imports systembase.table

Public Class Sample7

    Public WithEvents ItmCut As New ToolStripMenuItem("切り取り")
    Public WithEvents ItmCopy As New ToolStripMenuItem("コピー")
    Public WithEvents ItmPaste As New ToolStripMenuItem("貼り付け")
    Public WithEvents ItmUndo As New ToolStripMenuItem("アンドゥ")
    Public WithEvents ItmRedo As New ToolStripMenuItem("リドゥ")

    Private Sub Sample7_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim rp As New UTable.CRecordProvider
        With New CLayoutBuilder
            rp.AddField("_", New CCaptionFieldProvider("", True), .Next)
            rp.AddField("0", New CTextFieldProvider(), .Next)
            rp.AddField("1", New CTextFieldProvider(), .Next)
            rp.AddField("2", New CTextFieldProvider(), .Next)
            rp.AddField("3", New CTextFieldProvider(), .Next)
            rp.AddField("4", New CTextFieldProvider(), .Next)
            rp.AddField("del", New CButtonFieldProvider("削除"), .Next)
        End With
        Me.Table.Content.SetRecordProvider(rp)
        Me.Table.CreateCaption()
        Using Me.Table.RenderBlock
            For i As Integer = 1 To 10
                Me.Table.Content.AddRecord()
            Next
        End Using
        Me.Table.Cols.SetSize(30)
        Me.Table.UndoBufferEnabled = True
        Me.Table.Setting.UserRangeSelectable = True
        Me.Table.Setting.UserSortable = UTable.EAllow.ALLOW
        Me.Table.NotSelectableCols = 1
    End Sub

    Private Sub Table_FieldButtonClick(ByVal field As systembase.table.UTable.CField) Handles Table.FieldButtonClick
        Select Case field.Key
            Case "del"
                field.Content.RemoveRecord(field.Record)
        End Select
    End Sub

    Private Sub Table_LayoutUpdating(ByVal table As systembase.table.UTable) Handles Table.LayoutUpdating
        Using Me.Table.RenderBlock
            Dim i As Integer = 1
            For Each r As UTable.CRecord In Me.Table.Content.Records
                r.Fields("_").Value = i
                i += 1
            Next
        End Using
    End Sub

    Private Sub Table_MouseDown(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Table.MouseDown
        If e.Button = Windows.Forms.MouseButtons.Right Then
            Dim menu As New ContextMenuStrip
            menu.Items.Add(Me.ItmCut)
            menu.Items.Add(Me.ItmCopy)
            menu.Items.Add(Me.ItmPaste)
            menu.Items.Add(Me.ItmUndo)
            menu.Items.Add(Me.ItmRedo)
            menu.Show(Cursor.Position)
        End If
    End Sub

    Private Sub ItmCopy_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ItmCopy.Click
        Me.Table.ClipboardCopy()
    End Sub

    Private Sub ItmPaste_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ItmPaste.Click
        Me.Table.ClipboardPaste()
    End Sub

    Private Sub ItmCut_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ItmCut.Click
        Me.Table.ClipboardCopy()
        If Me.Table.SelectRange IsNot Nothing Then
            Me.Table.SelectRange.FieldsClear()
        ElseIf Me.Table.FocusField IsNot Nothing Then
            Me.Table.FocusField.Clear()
        End If
    End Sub

    Private Sub ItmUndo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ItmUndo.Click
        Me.Table.Undo()
    End Sub

    Private Sub ItmRedo_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles ItmRedo.Click
        Me.Table.Redo()
    End Sub

    Private Sub BtnAddRecord_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnAddRecord.Click
        Me.Table.Content.AddRecord()
    End Sub

    Private Sub BtnClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles BtnClear.Click
        Me.Table.Content.ClearRecord()
    End Sub

End Class