' table/LayoutBuilder.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Public Class CLayoutBuilder

    Public Enum EOrientation
        COL
        ROW
    End Enum

    Private layers As New Stack(Of CLayer)

    Public Sub New()
        Me.New(EOrientation.COL)
    End Sub

    Public Sub New(ByVal orientation As EOrientation)
        Me.layers.Push(New CLayer(orientation))
    End Sub

    Public Function Ascend() As CLayoutBuilder
        Return Me.Ascend(EOrientation.COL)
    End Function

    Public Function Ascend(ByVal orientation As EOrientation) As CLayoutBuilder
        Me.layers.Push(New CLayer(orientation, Me.layers.Peek))
        Return Me
    End Function

    Public Function Descend() As CLayoutBuilder
        Dim l As CLayer = Me.layers.Pop
        With Me.layers.Peek
            Select Case .Orientation
                Case EOrientation.COL
                    .Col = l.Col + 1
                Case EOrientation.ROW
                    .Row = .Row + 1
            End Select
        End With
        Return Me
    End Function

    Public Function [Set](ByVal row As Integer, ByVal col As Integer) As CLayoutBuilder
        With Me.layers.Peek
            .Row = row
            .Col = col
        End With
        Return Me
    End Function

    Public Function [Next]() As UTable.CGrid.CRegion
        Return Me.Next(1, 1)
    End Function

    Public Function [Next](ByVal rows As Integer, ByVal cols As Integer) As UTable.CGrid.CRegion
        Dim ret As UTable.CGrid.CRegion
        With Me.layers.Peek
            ret = New UTable.CGrid.CRegion(.Row, .Col, rows, cols)
            Select Case .Orientation
                Case EOrientation.COL
                    Me.Skip(cols)
                Case EOrientation.ROW
                    Me.Skip(rows)
            End Select
        End With
        Return ret
    End Function

    Public Function Skip() As CLayoutBuilder
        Return Skip(1)
    End Function

    Public Function Skip(ByVal [step] As Integer) As CLayoutBuilder
        With Me.layers.Peek
            Select Case .Orientation
                Case EOrientation.COL
                    .Col += [step]
                Case EOrientation.ROW
                    .Row += [step]
            End Select
        End With
        Return Me
    End Function

    Public Function Break() As CLayoutBuilder
        Return Me.Break(1)
    End Function

    Public Function Break(ByVal [step] As Integer) As CLayoutBuilder
        With Me.layers.Peek
            Select Case .Orientation
                Case EOrientation.COL
                    .Col = 0
                    .Row += [step]
                Case EOrientation.ROW
                    .Row = 0
                    .Col += [step]
            End Select
        End With
        Return Me
    End Function

    Class CLayer
        Public Orientation As EOrientation
        Public Row As Integer = 0
        Public Col As Integer = 0
        Public Sub New(ByVal orientation As EOrientation)
            Me.Orientation = orientation
        End Sub
        Public Sub New(ByVal orientation As EOrientation, ByVal layer As CLayer)
            Me.New(orientation)
            Me.Row = layer.Row
            Me.Col = layer.Col
        End Sub
    End Class

End Class
