' table/Field.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Public Class CFieldDesc
        Public CreateCaption As Boolean = True
        Public UserSortable As EAllow = EAllow.DEFAULT
        Public MergeCaption As Object = Nothing
        Public Comparer As CComparer = Nothing
        Public Layout As CGrid.CRegion
        Public Provider As IFieldProvider
        Public VerticalMerge As Boolean = False

        Private _Setting As UTable.CSetting
        Private _Setting2 As UTable.CSetting

        Public Sub New()
        End Sub

        Public Sub New(ByVal provider As IFieldProvider, ByVal layout As CGrid.CRegion)
            Me.Initialize(provider, layout)
        End Sub

        Public Sub Initialize(ByVal provider As IFieldProvider, ByVal layout As CGrid.CRegion)
            Me.Provider = provider
            Me.Layout = layout
            Me.Setting = provider.Setting
        End Sub

        Public Function HasSetting() As Boolean
            Return Me._Setting IsNot Nothing
        End Function

        Public Sub ClearSetting()
            Me.Setting = Nothing
        End Sub

        Public Property Setting() As UTable.CSetting
            Get
                If Me._Setting Is Nothing Then
                    Me._Setting = New UTable.CSetting
                End If
                Return Me._Setting
            End Get
            Set(ByVal value As UTable.CSetting)
                Me._Setting = value
            End Set
        End Property

        Public Function HasSetting2() As Boolean
            Return Me._Setting2 IsNot Nothing
        End Function

        Public Sub ClearSetting2()
            Me.Setting2 = Nothing
        End Sub

        Public Property Setting2() As UTable.CSetting
            Get
                If Me._Setting2 Is Nothing Then
                    Me._Setting2 = New UTable.CSetting
                End If
                Return Me._Setting2
            End Get
            Set(ByVal value As UTable.CSetting)
                Me._Setting2 = value
            End Set
        End Property

    End Class

    Public Class CField
        Public Key As Object
        Public Desc As CFieldDesc
        Public Record As CRecord
        Public Decorator As IFieldDecorator = Nothing
        Public Event Validating(ByVal field As CField, ByVal e As System.ComponentModel.CancelEventArgs)
        Public Event Validated(ByVal field As CField)
        Public Event Entering(ByVal field As CField, ByRef cancel As Boolean)
        Public Event Enter(ByVal field As CField)
        Public Event Leave(ByVal field As CField)
        Public Event MouseDown(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        Public Event MouseMove(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        Public Event MouseUp(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        Public Event Click(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        Public Event DoubleClick(ByVal field As CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        Public Event KeyDown(ByVal field As CField, ByVal e As System.Windows.Forms.KeyEventArgs)
        Public Event KeyUp(ByVal field As CField, ByVal e As System.Windows.Forms.KeyEventArgs)
        Public Event KeyPress(ByVal field As CField, ByVal e As System.Windows.Forms.KeyPressEventArgs)
        Public Event ValueChanged(ByVal field As CField)
        Public Event EditorValueChanged(ByVal field As CField)
        Public Event EditStarting(ByVal field As CField, ByRef editable As EAllow)
        Public Event EditStart(ByVal field As CField, ByVal editor As IEditor)
        Public Event EditFinished(ByVal field As CField)
        Public Event ButtonClick(ByVal field As CField)
        Public Event Selected(ByVal field As CField, ByRef handled As Boolean)
        Public Event FocusNextField(ByVal field As CField, ByVal forward As Boolean, ByRef handled As Boolean)
        Public Event FocusNextControl(ByVal field As CField, ByVal forward As Boolean, ByRef handled As Boolean)

        Private _Value As Object
        Private _Setting As UTable.CSetting = Nothing

        Friend Sub Init(ByVal key As Object, _
                        ByVal record As CRecord, _
                        ByVal fieldDesc As CFieldDesc)
            Me.Key = key
            Me.Record = record
            Me.Desc = fieldDesc
        End Sub

        Public Function HasSetting() As Boolean
            Return Me._Setting IsNot Nothing
        End Function

        Public Sub ClearSetting()
            Me.Setting = Nothing
        End Sub

        Public Property Setting() As UTable.CSetting
            Get
                If Me._Setting Is Nothing Then
                    Me._Setting = New UTable.CSetting
                End If
                Return Me._Setting
            End Get
            Set(ByVal value As UTable.CSetting)
                Me._Setting = value
            End Set
        End Property

        Public Overridable Property Value() As Object
            Get
                If Me.Editor IsNot Nothing Then
                    Return Me.Editor.Value
                ElseIf Me.valueBuffer IsNot Nothing Then
                    Return Me.valueBuffer.Value
                Else
                    Return Me.rawValue
                End If
            End Get
            Set(ByVal value As Object)
                Using Me.Table.RenderBlock
                    Dim v As Object = Me.Desc.Provider.ValueRegularize(value, Me.Editor)
                    If Me.Editor IsNot Nothing Then
                        Me.Editor.Value = v
                    ElseIf Me.valueBuffer IsNot Nothing Then
                        Me.valueBuffer.Value = v
                    Else
                        Me.ValueCommit(v)
                    End If
                End Using
            End Set
        End Property

        Public Sub ValueCommit(ByVal v As Object)
            Me.ValueCommit(v, Nothing)
        End Sub

        Friend Sub ValueCommit(ByVal v As Object, ByVal fieldModify As CFieldModify)
            Dim _fieldModify As CFieldModify = fieldModify
            If _fieldModify Is Nothing Then
                _fieldModify = Me.Desc.Provider.CreateModifyField(Me)
            End If
            Me.rawValue = v
            If _fieldModify.Modified(Me) Then
                Me.Table.raiseFieldValueChanged(Me)
                If Me.Table.UndoBufferEnabled AndAlso Me.Desc.Provider.UndoEnabled Then
                    _fieldModify.SetUp(Me)
                    Me.Content.addModify(_fieldModify)
                End If
                Me.extend_on_setValue()
            End If
        End Sub

        Public Function CommittedValue() As Object
            Return Me.rawValue
        End Function

        Protected Overridable Property rawValue() As Object
            Get
                Return Me._Value
            End Get
            Set(ByVal value As Object)
                Me._Value = value
            End Set
        End Property

        Public Function LeftCol() As CGrid
            For i As Integer = 0 To Me.Desc.Layout.Cols - 1
                Dim c As CGrid = Me.Table.Cols(Me.Desc.Layout.Col + i)
                If c.Visible Then
                    Return c
                End If
            Next
            Return Nothing
        End Function

        Public Function RightCol() As CGrid
            For i As Integer = Me.Desc.Layout.Cols - 1 To 0 Step -1
                Dim c As CGrid = Me.Table.Cols(Me.Desc.Layout.Col + i)
                If c.Visible Then
                    Return c
                End If
            Next
            Return Nothing
        End Function

        Public Function TopRow() As CGrid
            For i As Integer = 0 To Me.Desc.Layout.Rows - 1
                Dim r As CGrid = Me.Record.Rows(Me.Desc.Layout.Row + i)
                If r.Visible Then
                    Return r
                End If
            Next
            Return Nothing
        End Function

        Public Function BottomRow() As CGrid
            For i As Integer = Me.Desc.Layout.Rows - 1 To 0 Step -1
                Dim r As CGrid = Me.Record.Rows(Me.Desc.Layout.Row + i)
                If r.Visible Then
                    Return r
                End If
            Next
            Return Nothing
        End Function

        Public Function Content() As UTable.CContent
            Return Record.Content
        End Function

        Public Function Table() As UTable
            Return Me.Record.Table
        End Function

        Public Function TopLevelContent() As CContent
            Return Me.Record.TopLevelContent
        End Function

        Public Function TopLevelRecord() As CRecord
            Return Me.Record.TopLevelRecord
        End Function

        Public Function Editable() As EAllow
            Dim e As EAllow = Me.DynamicSetting.Editable
            Me.Table.raiseEditStarting(Me, e)
            Return e
        End Function

        Public Sub Visualize()
            Me.Record.Visualize()
        End Sub

        Public Function Focusable() As Boolean
            If Me.Desc.Layout Is Nothing OrElse _
               Not Me.Desc.Provider.Focusable Then
                Return False
            End If
            Dim c As CContent = Me.Content
            Do
                If Not c.Enabled Then
                    Return False
                End If
                If c.ParentRecord IsNot Nothing Then
                    c = c.ParentRecord.Content
                Else
                    Exit Do
                End If
            Loop
            Dim r As CRecord = Me.Record
            Do While r IsNot Nothing
                If Not r.Visible OrElse Not r.Content.Visible Then
                    Return False
                End If
                r = r.Content.ParentRecord
            Loop

            Dim t As Boolean = False
            For i As Integer = 0 To Me.Desc.Layout.Cols - 1
                If Me.Table.Cols(Me.Desc.Layout.Col + i).Visible Then
                    t = True
                    Exit For
                End If
            Next
            If Not t Then
                Return False
            End If

            For i As Integer = 0 To Me.Desc.Layout.Rows - 1
                If Me.Record.Rows(Me.Desc.Layout.Row + i).Visible Then
                    Return True
                End If
            Next
        End Function

        Public Sub [Focus]()
            Me.Table.FocusField = Me
        End Sub

        Public Function Focused() As Boolean
            Return Me Is Me.Table.FocusField
        End Function

        Public Function Editor() As IEditor
            If Me.Focused Then
                Return Me.Table.Editor
            Else
                Return Nothing
            End If
        End Function

        Public Function DynamicSetting() As CDynamicSetting
            Return New CDynamicSetting(Me)
        End Function

        Friend Sub raiseValidating(ByVal e As System.ComponentModel.CancelEventArgs)
            RaiseEvent Validating(Me, e)
        End Sub

        Friend Sub raiseValidated()
            RaiseEvent Validated(Me)
        End Sub

        Friend Sub raiseValueChanged()
            RaiseEvent ValueChanged(Me)
        End Sub

        Friend Sub raiseEditorValueChanged()
            RaiseEvent EditorValueChanged(Me)
        End Sub

        Friend Sub raiseEntering(ByRef cancel As Boolean)
            RaiseEvent Entering(Me, cancel)
        End Sub

        Friend Sub raiseEnter()
            RaiseEvent Enter(Me)
        End Sub

        Friend Sub raiseLeave()
            RaiseEvent Leave(Me)
        End Sub

        Friend Sub raiseEditStarting(ByRef editable As EAllow)
            RaiseEvent EditStarting(Me, editable)
        End Sub

        Friend Sub raiseEditStart(ByVal editor As IEditor)
            RaiseEvent EditStart(Me, editor)
        End Sub

        Friend Sub raiseEditFinished()
            RaiseEvent EditFinished(Me)
        End Sub

        Friend Sub raiseMouseDown(ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
            RaiseEvent MouseDown(Me, location, e)
        End Sub

        Friend Sub raiseMouseUp(ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
            RaiseEvent MouseUp(Me, location, e)
        End Sub

        Friend Sub raiseMouseMove(ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
            RaiseEvent MouseMove(Me, location, e)
        End Sub

        Friend Sub raiseClick(ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
            RaiseEvent Click(Me, location, e)
        End Sub

        Friend Sub raiseDoubleClick(ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
            RaiseEvent DoubleClick(Me, location, e)
        End Sub

        Friend Sub raiseKeyDown(ByVal e As System.Windows.Forms.KeyEventArgs)
            RaiseEvent KeyDown(Me, e)
        End Sub

        Friend Sub raiseKeyUp(ByVal e As System.Windows.Forms.KeyEventArgs)
            RaiseEvent KeyUp(Me, e)
        End Sub

        Friend Sub raiseKeyPress(ByVal e As System.Windows.Forms.KeyPressEventArgs)
            RaiseEvent KeyPress(Me, e)
        End Sub

        Friend Sub raiseButtonClick()
            RaiseEvent ButtonClick(Me)
        End Sub

        Friend Sub raiseSelected(ByRef handled As Boolean)
            RaiseEvent Selected(Me, handled)
        End Sub

        Friend Sub raiseFocusNextField(ByVal forward As Boolean, ByRef handled As Boolean)
            RaiseEvent FocusNextField(Me, forward, handled)
        End Sub

        Friend Sub raiseFocusNextControl(ByVal forward As Boolean, ByRef handled As Boolean)
            RaiseEvent FocusNextControl(Me, forward, handled)
        End Sub

        Private Class _CValueBuffer
            Implements IDisposable

            Public field As CField
            Public Value As Object
            Public Cancel As Boolean = False

            Public Sub New(ByVal field As CField, ByVal value As Object)
                Me.field = field
                Me.Value = value
            End Sub

            Private disposedValue As Boolean = False
            Protected Overridable Sub Dispose(ByVal disposing As Boolean)
                If Not Me.disposedValue Then
                    Me.field.valueBuffer = Nothing
                    If Not Cancel Then
                        Me.field.ValueCommit(Me.Value)
                    End If
                End If
                Me.disposedValue = True
            End Sub

#Region " IDisposable Support "
            ' ̃R[h́Aj\ȃp^[𐳂ł悤 Visual Basic ɂĒǉ܂B
            Public Sub Dispose() Implements IDisposable.Dispose
                ' ̃R[hύXȂłBN[Abv R[h Dispose(ByVal disposing As Boolean) ɋLq܂B
                Dispose(True)
                GC.SuppressFinalize(Me)
            End Sub
#End Region

        End Class

        Private valueBuffer As _CValueBuffer = Nothing
        Private Function valueBufferBlock(ByVal value As Object) As _CValueBuffer
            Me.valueBuffer = New _CValueBuffer(Me, value)
            Return Me.valueBuffer
        End Function

        Public Function SetValueIfValidated(ByVal value As Object) As Boolean
            Using Me.Table.RenderBlock
                Using b As UTable.CField._CValueBuffer = Me.valueBufferBlock(value)
                    Dim e As New System.ComponentModel.CancelEventArgs
                    Me.Table.raiseFieldValidating(Me, e)
                    If e.Cancel Then
                        b.Cancel = True
                    Else
                        Me.Table.raiseFieldValidated(Me)
                    End If
                    Return Not b.Cancel
                End Using
            End Using
        End Function

        Public Overridable Sub Clear()
            SetValueIfValidated(Nothing)
        End Sub

        Public Function GetRectangle() As Rectangle
            Return Me.GetRectangle(Me.Record.LayoutCache.Top, 0)
        End Function

        Friend Function getRectangle(ByVal top_row As Integer, ByVal top_col As Integer) As Rectangle
            Return CGrid.GetRectangle(Me.Table.Cols, Me.Record.Rows, Me.Desc.Layout, top_row, top_col)
        End Function

        Public Function NextField() As CField
            Dim l As List(Of CField) = Me.Record.tabOrderdList
            Dim i As Integer = l.IndexOf(Me) + 1
            Do While i < l.Count
                If l(i).Focusable AndAlso l(i).DynamicSetting.TabStop = ETabStop.STOP Then
                    Return l(i)
                End If
                i += 1
            Loop
            Dim r As CRecord = Me.Record.LayoutCache.NextRecord
            Do While r IsNot Nothing
                Dim f As CField = r.DefaultField
                If f IsNot Nothing Then
                    Return f
                End If
                r = r.LayoutCache.NextRecord
            Loop
            Return Nothing
        End Function

        Public Function PrevField() As CField
            Dim l As List(Of CField) = Me.Record.tabOrderdList
            Dim i As Integer = l.IndexOf(Me) - 1
            Do While i >= 0
                If l(i).Focusable AndAlso l(i).DynamicSetting.TabStop = ETabStop.STOP Then
                    Return l(i)
                End If
                i -= 1
            Loop
            Dim r As CRecord = Me.Record.LayoutCache.PrevRecord
            Do While r IsNot Nothing
                Dim f As CField = r.LastField
                If f IsNot Nothing Then
                    Return f
                End If
                r = r.LayoutCache.PrevRecord
            Loop
            Return Nothing
        End Function

        Public Function NextEditableField() As CField
            Dim f As CField = Me.NextField
            Do While f IsNot Nothing
                If f.Editable.Equals(EAllow.ALLOW) Then
                    Return f
                End If
                f = f.NextField
            Loop
            Return Nothing
        End Function

        Public Function PrevEditableField() As CField
            Dim f As CField = Me.PrevField
            Do While f IsNot Nothing
                If f.Editable.Equals(EAllow.ALLOW) Then
                    Return f
                End If
                f = f.PrevField
            Loop
            Return Nothing
        End Function

        Public Sub ClipboardCopy()
            Dim t As String = _SanitizeClipboard(Me.Desc.Provider.Clipboard(Me)) & vbCrLf
            Clipboard.SetText(t)
        End Sub

        Public Sub ClipboardPaste()
            If Clipboard.ContainsText AndAlso Me.Focusable AndAlso Me.Editable.Equals(EAllow.ALLOW) Then
                Dim v As List(Of List(Of String)) = _ParseClipboard(Clipboard.GetText)
                If v.Count > 0 AndAlso v(0).Count > 0 Then
                    Me.Desc.Provider.Clipboard(Me) = v(0)(0)
                End If
            End If
        End Sub

    End Class

    Protected Shared Function _SanitizeClipboard(ByVal v As String) As String
        Dim ret As String = v
        If ret Is Nothing Then
            ret = ""
        End If
        If ret.Contains(vbCr) Then
            ret = ret.Replace(vbCr, "")
            ret = ret.Replace("""", """""")
            ret = """" & ret & """"
        End If
        Return ret
    End Function

    Protected Shared Function _ParseClipboard(ByVal s As String) As List(Of List(Of String))        
        Dim ret As New List(Of List(Of String))
        Dim _s As String = s
        If s.EndsWith(vbCrLf) Then
            _s = s.Substring(0, s.Length - 2)
        End If
        For Each _v As String In _s.Split(vbCr)
            If _v.StartsWith(vbLf) Then
                _v = _v.Substring(1)
            End If
            Dim l As New List(Of String)
            For Each v As String In _v.Split(vbTab)
                If v.Contains(vbLf) Then
                    v = v.Replace(vbLf, vbCrLf)
                    If v.StartsWith("""") And v.Length >= 2 Then
                        v = v.Substring(1, v.Length - 2)
                    End If
                    v = v.Replace("""""", """")
                End If
                l.Add(v)
            Next
            ret.Add(l)
        Next
        Return ret
    End Function

End Class
