﻿' table/Content.vb
'
' Copyright (c) 2008-2011, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Partial Class UTable

    Public Interface IModify
        Sub Undo(ByVal content As UTable.CContent)
        Sub Redo(ByVal content As UTable.CContent)
    End Interface

    Public Class CChildModify
        Implements IModify

        Public RecordIndex As Integer
        Public ChildModify As IModify

        Public Sub New(ByVal record As CRecord, ByVal childModify As IModify)
            Me.RecordIndex = record.Index
            Me.ChildModify = childModify
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IModify.Redo
            Me.ChildModify.Redo(content.Records(Me.RecordIndex).Child)
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IModify.Undo
            Me.ChildModify.Undo(content.Records(Me.RecordIndex).Child)
        End Sub

    End Class

    Public Class CFieldModify
        Implements IModify

        Public RecordIndex As Integer
        Public Key As Object
        Public BakValue As Object
        Public NewValue As Object

        Public Sub New(ByVal field As CField)
            Me.BakValue = field.Value
        End Sub

        Public Overridable Function Modified(ByVal field As CField) As Boolean
            Me.NewValue = field.Value
            If Me.BakValue Is Nothing Then
                Return Me.NewValue IsNot Nothing
            Else
                Return Not Me.BakValue.Equals(Me.NewValue)
            End If
        End Function

        Public Sub SetUp(ByVal field As CField)
            Me.RecordIndex = field.Record.Index
            Me.Key = field.Key
        End Sub

        Public Overridable Sub Redo(ByVal content As CContent) Implements IModify.Redo
            Dim f As CField = getField(content)
            If f IsNot Nothing Then
                f.Value = Me.NewValue
            End If
        End Sub

        Public Overridable Sub Undo(ByVal content As CContent) Implements IModify.Undo
            Dim f As CField = getField(content)
            If f IsNot Nothing Then
                f.Value = Me.BakValue
            End If
        End Sub

        Protected Function getField(ByVal content As CContent) As CField
            If Me.RecordIndex >= content.Records.Count Then
                Return Nothing
            End If
            Dim r As CRecord = content.Records(Me.RecordIndex)
            If Not r.Fields.ContainsKey(Me.Key) Then
                Return Nothing
            End If
            Return r.Fields(Me.Key)
        End Function

    End Class

    Public Class CAddRecordModify
        Implements IModify

        Public RecordIndex As Integer

        Public Sub New(ByVal recordIndex As Integer)
            Me.RecordIndex = recordIndex
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IModify.Redo
            If Me.RecordIndex <= content.Records.Count Then
                content.Records.Insert(Me.RecordIndex, content.CreateRecord)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IModify.Undo
            If Me.RecordIndex < content.Records.Count Then
                content.Records.RemoveAt(Me.RecordIndex)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

    End Class

    Public Class CRemoveRecordModify
        Implements IModify

        Public RecordIndex As Integer
        Public Fields As New List(Of CFieldModify)
        Public ChildBuffer As CContentModifyBuffer = Nothing

        Public Sub New(ByVal record As CRecord)
            Me.RecordIndex = record.Index
            For Each k As Object In record.Fields.Keys
                Dim f As CField = record.Fields(k)
                If f.Desc.Provider.UndoEnabled Then
                    Dim modify As CFieldModify = f.Desc.Provider.CreateModifyField(f)
                    modify.SetUp(f)
                    Me.Fields.Add(modify)
                End If
            Next
            If record.Child IsNot Nothing Then
                Me.ChildBuffer = New CContentModifyBuffer(record.Child)
            End If
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IModify.Redo
            If Me.RecordIndex < content.Records.Count Then
                content.Records.RemoveAt(Me.RecordIndex)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IModify.Undo
            If Me.RecordIndex <= content.Records.Count Then
                Dim r As CRecord = content.CreateRecord
                content.Records.Insert(Me.RecordIndex, r)
                For Each m As CFieldModify In Me.Fields
                    m.Undo(content)
                Next
                If Me.ChildBuffer IsNot Nothing AndAlso r.Child IsNot Nothing Then
                    Me.ChildBuffer.Undo(r.Child)
                End If
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

    End Class

    Public Class CMoveRecordModify
        Implements IModify

        Public RecordIndex As Integer
        Public BakRecordIndex As Integer

        Public Sub New(ByVal record As CRecord, ByVal recordIndex As Integer)
            Me.New(record.Index, recordIndex)
        End Sub

        Public Sub New(ByVal bakRecordIndex As Integer, ByVal recordIndex As Integer)
            Me.BakRecordIndex = bakRecordIndex
            Me.RecordIndex = recordIndex
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IModify.Redo
            If Me.RecordIndex < content.Records.Count AndAlso _
               Me.BakRecordIndex < content.Records.Count Then
                Dim r As CRecord = content.Records(Me.BakRecordIndex)
                content.Records.RemoveAt(Me.BakRecordIndex)
                content.Records.Insert(Me.RecordIndex, r)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IModify.Undo
            If Me.RecordIndex < content.Records.Count AndAlso _
               Me.BakRecordIndex < content.Records.Count Then
                Dim r As CRecord = content.Records(Me.RecordIndex)
                content.Records.RemoveAt(Me.RecordIndex)
                content.Records.Insert(Me.BakRecordIndex, r)
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

    End Class

    Public Class CClearRecordModify
        Implements IModify

        Public Buffer As CContentModifyBuffer

        Public Sub New(ByVal content As CContent)
            Me.Buffer = New CContentModifyBuffer(content)
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IModify.Redo
            content.ClearRecord()
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IModify.Undo
            Me.Buffer.Undo(content)
            content.TopLevelContent.LayoutCacheInvalid = True
        End Sub

    End Class

    Public Class CSortModify
        Implements IModify

        Public RecordIndexss As List(Of Integer)

        Public Sub New(ByVal recordIndexes As List(Of Integer))
            Me.RecordIndexss = recordIndexes
        End Sub

        Public Sub Redo(ByVal content As CContent) Implements IModify.Redo
            If Me.RecordIndexss.Count = content.Records.Count Then
                Dim bak As List(Of CRecord) = content.Records
                content.Records = New List(Of CRecord)
                For Each i As Integer In Me.RecordIndexss
                    content.Records.Add(bak(i))
                Next
                content.Table.SortState.Field = Nothing
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

        Public Sub Undo(ByVal content As CContent) Implements IModify.Undo
            If Me.RecordIndexss.Count = content.Records.Count Then
                Dim rev As New Dictionary(Of Integer, Integer)
                For i As Integer = 0 To Me.RecordIndexss.Count - 1
                    rev.Add(Me.RecordIndexss(i), i)
                Next
                Dim bak As List(Of CRecord) = content.Records
                content.Records = New List(Of CRecord)
                For i As Integer = 0 To Me.RecordIndexss.Count - 1
                    content.Records.Add(bak(rev(i)))
                Next
                content.Table.SortState.Field = Nothing
                content.TopLevelContent.LayoutCacheInvalid = True
            End If
        End Sub

    End Class

    Public Class CContentModifyBuffer
        Public Fields As New List(Of CFieldModify)
        Public Records As New List(Of CContentModifyBuffer)
        Public Sub New(ByVal content As CContent)
            For Each r As CRecord In content.Records
                For Each k As Object In r.Fields.Keys
                    Dim f As CField = r.Fields(k)
                    If f.Desc.Provider.UndoEnabled Then
                        Dim modify As CFieldModify = f.Desc.Provider.CreateModifyField(f)
                        modify.SetUp(f)
                        Me.Fields.Add(modify)
                    End If
                Next
            Next
            For Each r As CRecord In content.Records
                If r.Child IsNot Nothing Then
                    Me.Records.Add(New CContentModifyBuffer(r.Child))
                Else
                    Me.Records.Add(Nothing)
                End If
            Next
        End Sub
        Public Sub Undo(ByVal content As CContent)
            For Each b As CContentModifyBuffer In Me.Records
                Dim r As UTable.CRecord = content.CreateRecord
                content.Records.Add(r)
                If b IsNot Nothing And r.Child IsNot Nothing Then
                    b.Undo(r.Child)
                End If
            Next
            For Each m As CFieldModify In Me.Fields
                m.Undo(content)
            Next
        End Sub
    End Class

    Public Class CModifyContainer
        Public Content As CContent
        Public Modify As IModify
        Public Sub New(ByVal content As CContent, ByVal modify As IModify)
            Me.Content = content
            Me.Modify = modify
        End Sub
    End Class

    Private _ignoreUndoBufferEnabled As Boolean = False

    Public Sub ClearUndoBuffer()
        If Me.UndoBuffer IsNot Nothing Then
            Me.UndoBuffer.Clear()
        End If
        If Me.RedoBuffer IsNot Nothing Then
            Me.RedoBuffer.Clear()
        End If
    End Sub

    Public Property UndoBufferEnabled() As Boolean
        Get
            Return Me._UndoBufferEnabled
        End Get
        Set(ByVal value As Boolean)
            Me._UndoBufferEnabled = value
            If Me.UndoBufferEnabled Then
                If Me.UndoBuffer Is Nothing Then
                    Me.UndoBuffer = New List(Of List(Of CModifyContainer))
                End If
                If Me.RedoBuffer Is Nothing Then
                    Me.RedoBuffer = New List(Of List(Of CModifyContainer))
                End If
            Else
                Me.UndoBuffer = Nothing
                Me.RedoBuffer = Nothing
            End If
        End Set
    End Property

    Friend Sub addModify(ByVal content As CContent, ByVal modify As IModify)
        If Me._ignoreUndoBufferEnabled Or Me.UndoBuffer Is Nothing Then
            Exit Sub
        End If
        If Me._EditBlock IsNot Nothing Then
            Me._EditBlock.ModifyContainers.Add(New CModifyContainer(content, modify))
        Else
            Dim l As New List(Of CModifyContainer)
            l.Add(New CModifyContainer(content, modify))
            Me.addModify(l)
        End If
    End Sub

    Friend Sub addModify(ByVal modifyContainers As List(Of CModifyContainer))
        If Me._ignoreUndoBufferEnabled Or Me.UndoBuffer Is Nothing Then
            Exit Sub
        End If
        Me.UndoBuffer.Add(modifyContainers)
        Me.RedoBuffer.Clear()
        If Me.UndoBuffer.Count > Me.UndoBufferMax Then
            Me.UndoBuffer.RemoveRange(0, Me.UndoBuffer.Count - Me.UndoBufferMax)
        End If
    End Sub

    Public Sub Undo()
        If Me.UndoBuffer Is Nothing OrElse Me.UndoBuffer.Count = 0 Then
            Exit Sub
        End If
        Me._ignoreUndoBufferEnabled = True
        Try
            Dim i As Integer = Me.UndoBuffer.Count - 1
            Dim mcs As List(Of CModifyContainer) = Me.UndoBuffer(i)
            Using Me.RenderBlock
                For j As Integer = mcs.Count - 1 To 0 Step -1
                    Dim mc As CModifyContainer = mcs(j)
                    mc.Modify.Undo(mc.Content)
                Next
                Me.RedoBuffer.Add(mcs)
                Me.UndoBuffer.RemoveAt(i)
            End Using
            RaiseEvent UndoFinished(Me, mcs)
        Finally
            Me._ignoreUndoBufferEnabled = False
        End Try
    End Sub

    Public Sub Redo()
        If Me.RedoBuffer Is Nothing OrElse Me.RedoBuffer.Count = 0 Then
            Exit Sub
        End If
        Me._ignoreUndoBufferEnabled = True
        Try
            Dim i As Integer = Me.RedoBuffer.Count - 1
            Dim mcs As List(Of CModifyContainer) = Me.RedoBuffer(i)
            Using Me.RenderBlock
                For j As Integer = 0 To mcs.Count - 1
                    Dim mc As CModifyContainer = mcs(j)
                    mc.Modify.Redo(mc.Content)
                Next
                Me.UndoBuffer.Add(mcs)
                Me.RedoBuffer.RemoveAt(i)
            End Using
            RaiseEvent RedoFinished(Me, mcs)
        Finally
            Me._ignoreUndoBufferEnabled = False
        End Try
    End Sub

End Class