package org.wicketja.pages;

import java.text.DateFormat;
import java.util.Locale;

import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.wicketja.dao.NewsDao;
import org.wicketja.dao.NewsDaoImpl;
import org.wicketja.model.NewsEntry;

/**
 * 最近のニュースを掲載するページクラスです。
 * @author Yoichiro Tanaka
 * @author Tsutomu YANO
 */
@SuppressWarnings("serial")
public class NewsPage extends AbstractWebPage {

    //DIコンテナを入れた場合はインジェクションする
    protected NewsDao newsDao = null;
    
    IModel newsModel = new LoadableDetachableModel() {
        @Override
        protected Object load() {
            newsDao = new NewsDaoImpl(getEntityManager());
            return newsDao.findAll();
        }
    };

    /**
     * このオブジェクトが生成される時に呼び出されます。
     * @param params ページパラメータ
     */
    public NewsPage(PageParameters params) {
        super();
        add(new ListView("newsEntry", newsModel) {

            @Override
            protected void populateItem(ListItem item) {
                NewsEntry newsEntry = (NewsEntry) item.getModelObject();

                item.add(new Label("newsTitle", newsEntry.getTitle()));
                item.add(new Label("newsDate", DateFormat.getDateInstance(
                        DateFormat.FULL, Locale.JAPAN).format(newsEntry.getRegisterDate().getTime())));
                item.add(new Label("newsContent", newsEntry.getContent()).setEscapeModelStrings(false));
            }
        });
    }
}
