﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Nmea
{
    public class Parser : Yubeshi.Parser
    {
        #region type definitions
        //delegate bool TrialParser(byte[] sentence, out Packet packet);
        #endregion

        #region fields
        private static readonly Protocol[] protocols =
                                            new Protocol[] { Protocol.Nmea };
        private static Dictionary<string, TrialParser> gpParsers;
        private static Encoding ascii = Encoding.ASCII;

        #endregion

        #region constructors
        static Parser()
        {
            gpParsers = new Dictionary<string, TrialParser>();
            gpParsers["DTM"] = GpDtm.TryParse;
            //gpParsers["GBS"] = GpGbs.TryParse;
            gpParsers["GGA"] = GpGga.TryParse;
            gpParsers["GLL"] = GpGll.TryParse;
            gpParsers["GRS"] = GpGrs.TryParse;
            gpParsers["GSA"] = GpGsa.TryParse;
        }

        #endregion

        #region public method

        public new static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            packet = null;
            // $XXXX,*CCcl
            if (sentence.Length < 11 || sentence[0] != '$')
            {
                return false;
            }
            if (sentence[1] == 'G')
            { 
                if (sentence[2] == 'P') // GPS
                {
                    string format = ascii.GetString(sentence, 3, 3);
                    if (gpParsers.ContainsKey(format))
                    {
                        return gpParsers[format](sentence, out packet);
                    }
                    return false;
                }
            }
            else if (sentence[1] == 'P')
            { 
            
            }
            return false;
        }

        public static int SearchSyncFrom(byte[] input)
        {
            return SearchSyncFrom(input, 0);
        }

        public static int SearchSyncFrom(byte[] input, int index)
        {
            return OctetString.IndexOf(input, (byte)'$', index);
        }

        #endregion
    }
}
