﻿/*
 *	Yubeshi GPS Parser
 *
 *	This software is distributed under a zlib-style license.
 *	See license.txt for more information.
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace Yubeshi.Ubx
{
    public class NavDop : Packet
    {
        #region constructors

        public NavDop(byte[] sentence, int length)
            : base(sentence, length)
        {
        }

        #endregion

        #region properties

        public decimal TimeOfWeek
        {
            get
            {
                return BitConverter.ToUInt32(Raw, 6 + 0) * 1e-3m;
            }
        }

        public double Geometric
        {
            get
            {
                return BitConverter.ToUInt16(Raw, 6 + 4) * 0.01;
            }
        }

        public double Position
        {
            get
            {
                return BitConverter.ToUInt16(Raw, 6 + 6) * 0.01;
            }
        }

        public double Time
        {
            get
            {
                return BitConverter.ToUInt16(Raw, 6 + 8) * 0.01;
            }
        }

        public double Vertical
        {
            get
            {
                return BitConverter.ToUInt16(Raw, 6 + 10) * 0.01;
            }
        }

        public double Horizonal
        {
            get
            {
                return BitConverter.ToUInt16(Raw, 6 + 12) * 0.01;
            }
        }

        public double Noarthing
        {
            get
            {
                return BitConverter.ToUInt16(Raw, 6 + 14) * 0.01;
            }
        }

        public double Easting
        {
            get
            {
                return BitConverter.ToUInt16(Raw, 6 + 16) * 0.01;
            }
        }

        #endregion

        #region public methods

        public static bool TryParse(byte[] sentence, out UnknownPacket packet)
        {
            return TryParse(sentence, out packet, MessageID.NavDop, 18, Build);
        }

        #endregion

        #region private methods

        private static Packet Build(byte[] sentence, int length)
        {
            return new NavDop(sentence, length);
        }

        #endregion
    }
}
